% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi.kappa.R
\name{pi.kappa}
\alias{pi.kappa}
\title{pi.kappa}
\usage{
pi.kappa(datax, mu0, tau0, guide = TRUE)
}
\arguments{
\item{datax}{Matrix containing the data in cartesian coordinates, where the number of rows is the number of observations and the number of columns is the dimension of the Euclidean space where the sphere is embebed.}

\item{mu0}{Vector containing the mean direction of the von Mises-Fisher guide.}

\item{tau0}{Numerical value containing the concentration of the von Mises-Fisher guide.}

\item{guide}{Logical; if TRUE, the estimator with a von Mises-Fisher as guide is computed. If FALSE, the classical kernel density estimator without guide is computed (equivalent to uniform guide).}
}
\value{
A numerical value with the selected data-driven smoothing parameter.
}
\description{
Function \code{pi.kappa} computes a plug-in type smoothing parameter for the parametrically guided (hyper)spherical kernel density estimator, equipped with a von Mises-Fisher guide.
}
\details{
See Alonso-Pena et al. (2023) for details.
}
\examples{
library(Directional)
library(movMF)
# Data generation
n<-200
mu<-matrix(c(0,0,1,0,0,-1),ncol=3,byrow=TRUE)
k<-c(7,2)
probs<-c(0.85,0.15)
datax<-rmovMF(n,k*mu,alpha=probs)
# Estimation of parameters of a vMF
param<-vmf.mle(datax)
mu0<-param$mu
tau0<-param$kappa
# Selection of the smoothing parameter
kappa <- pi.kappa(datax,mu0,tau0)
}
\references{
Alonso-Pena, M., Claeskens, G. and Gijbels, I. (2023) Nonparametric estimation of densities on the hypersphere using a parametric guide. Under review.
}
