% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_peripheral_compartment}
\alias{add_peripheral_compartment}
\title{add_peripheral_compartment}
\usage{
add_peripheral_compartment(model, name = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{name}{(str (optional)) Name of compartment to add peripheral to.}
}
\value{
(Model) Pharmpy model object
}
\description{
Add a peripheral distribution compartment to model

The rate of flow from the central to the peripheral compartment
will be parameterized as QPn / VC where VC is the volume of the central compartment.
The rate of flow from the peripheral to the central compartment
will be parameterized as QPn / VPn where VPn is the volumne of the added peripheral
compartment.

If name is set, the peripheral compartment will be added to the compartment
with the specified name instead.

Initial estimates:

==  ===================================================
n
==  ===================================================
1   (equation could not be rendered, see API doc on website)
2   (equation could not be rendered, see API doc on website)
==  ===================================================
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- add_peripheral_compartment(model)
model$statements$ode_system
}
}
\seealso{
set_peripheral_compartment

remove_peripheral_compartment
}
