#' Toxicity probability matrix
#'
#' A 6 dimension array providing the toxicity probability of different
#' scenarios. The dimension is 4 3 6 6 3 5 which represents scenario, cycle
#' effect, dose level, cycle number, toxicity type, and tox grade. Scenarios are
#' ordered in a way that the first scenario is MTD = dose 2, the second is MTD =
#' dose 3, the third is MTD = dose 4, and the fourth is MTD = dose 5. The three
#' Cycle effect trend are decreasing, flat, and increasing toxicity trend over
#' cycles. There are 6 doses, 6 cycles, 3 toxicity types and 5 toxicity grades.

"prob"

#' Efficacy response generation parameters
#'
#' A list of 4 records the parameters for efficacy measure generation. This
#' serves as an example of the parameter settings for efficacy measure
#' generation in function \code{SimPRMD}. Check \code{\link{eff_summary}} or
#' \code{\link{SimPRMD}} to see the examples of using dataset \code{eff} in
#' generating efficacy measure.
#'
#' @return \item{Dose_Cycle_Meff}{Dose-cycle mean efficacy matrix. An array of 4
#'   dimension providing the mean of the multivariate Gaussian distribution in
#'   efficacy data generation. The dimension of the Dose-cycle mean efficacy
#'   matrix is 5 5 6 6 which represents dose efficacy pattern, cycle efficacy
#'   pattern, dose and cycle. Patterns are ordered in a way that the first is
#'   increasing, the second is flat, the third is platform, the fourth is
#'   decreasing, and the fifth is quadratic efficacy across dose levels and
#'   cycles.}
#'
#'   \item{Sigma}{A 6 by 6 matrix, the covariance matrix of the multivariate
#'   Guassian distribution in efficacy data generation.}
#'
#'   \item{sd_trans}{A positive number controls the skewness of the distribution
#'   of the efficacy response}
#'
#'   \item{eff.M}{An array recording the corresponding mean of the generated
#'   efficacy data with parameters specified by \code{eff$Dose_Cycle_Meff},
#'   \code{eff$Sigma}, and \code{eff$sd_trans}}
#'

"eff"


#'A list of patient information
#'
#'The data "patlist_sim" is a trial generated by "SimPRMD". The model utilized
#'for generating trial is a 3-stage model with individualized dose modification.
#'The MTD = 4 and the MED = 1 since the dose-efficacy pattern when generating
#'the trial was set to be flat. The dose-toxicity trend and efficacy-cycle trend
#'are flat. There are in total 12 cohorts with 3 patients in each cohort. This
#'also serves as an example of the input data of function \code{\link{RunPRMD}}.
#'
#'@return
#'
#'\item{PatID}{denotes the patient ID where the elements are specified by cohort
#'and subject number. For example, "cohort2subject3" denotes the third subject
#'in the second cohort}
#'
#'\item{dose}{records the dose assigned for each patient on different cycles}
#'
#'\item{cycle}{shows the treatment cycle}
#'
#'\item{nTTP}{records th corresponding nTTP score.}
#'
#'\item{dlt}{indicates whether a DLT event is observed or not?}
#'
#'\item{efficacy}{provides the continuous efficacy for each cycle. The range of
#'efficacy measure is (0, 1).}

"patlist_sim"
