% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatenate_textgrids.R
\name{concatenate_textgrids}
\alias{concatenate_textgrids}
\title{Concatenate TextGrids}
\usage{
concatenate_textgrids(path, result_file_name = "concatenated")
}
\arguments{
\item{path}{path to the directory with soundfiles.}

\item{result_file_name}{name of the result and annotation files.}
}
\value{
no output
}
\description{
Creates a merged TextGrids from TextGrids files in a folder.
}
\examples{
# create two files in a temprary folder "test_folder"
t1 <- system.file("extdata", "test.TextGrid", package = "phonfieldwork")
t2 <- system.file("extdata", "post.TextGrid", package = "phonfieldwork")
tdir <- tempdir()
file.copy(c(t1, t2), tdir)

# here are two .wav files in a folder
list.files(tdir)
# [1] "post.TextGrid" "test.TextGrid" ...

# Concatenate all TextGrids from the folder into concatenated.TextGrid
concatenate_textgrids(path = tdir, result_file_name = "concatenated")

list.files(tdir)
# [1] "concatenated.TextGrid" "post.TextGrid" "test.TextGrid" ...
}
\author{
George Moroz <agricolamz@gmail.com>
}
