% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.tree.R
\name{load.tree}
\alias{load.tree}
\title{load tree}
\usage{
load.tree(treefile, ...)
}
\arguments{
\item{treefile}{Required. Path of phylogenetic tree to read}

\item{...}{Optional. Pass any other arguments to read.tree}
}
\value{
a \code{\link[phylobase]{phylo4}} tree object.
}
\description{
load a newick tree.
}
\details{
this is the recommended way to load a tree for use with phylocanvas. The reason is that
all of the javascript selector methods require that the nodes are named and the
selection of nodes based on names is straightforward with \code{\link[phylobase]{phylo4}}
objects. Therefore this function will read your newick tree, add names, and return a
 \code{\link[phylobase]{phylo4}}  object that can be easily manipulated and subsetted
generating custom displays.
}
\examples{
birdfile <- system.file("treedata/birdfamilies.tree", package="phylocanvas")
tree <- load.tree(birdfile)
}
