% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asdendrogram.R
\name{as.dendrogram.phylo}
\alias{as.dendrogram.phylo}
\title{Convert a "phylo" object to a dendrogram.}
\usage{
\method{as.dendrogram}{phylo}(object, ...)
}
\arguments{
\item{object}{an object of class "phylo".}

\item{...}{further arguments to be passed between methods.}
}
\value{
an object of class "dendrogram".
}
\description{
This function converts a "phylo" object (Paradis et al 2004)
  to a dendrogram.
}
\examples{
  newick <- "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);"
  x <- read.dendrogram(text = newick)
  y <- as.phylo(x)
  z <- as.dendrogram(y)
  identical(x, z)
}
\references{
Paradis E, Claude J, Strimmer K, (2004) APE: analyses of phylogenetics
  and evolution in R language. \emph{Bioinformatics} \strong{20}, 289-290.

  Paradis E (2008) Definition of Formats for Coding Phylogenetic Trees in R.
  \url{http://ape-package.ird.fr/misc/FormatTreeR_24Oct2012.pdf}

  Paradis E (2012) Analysis of Phylogenetics and Evolution with R
  (Second Edition). Springer, New York.
}
\author{
Shaun Wilkinson
}
