// Generated by rstantools.  Do not edit by hand.

/*
    phylopairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    phylopairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phylopairs.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_twoterm_lmm_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 49> locations_array__ =
  {" (found before start of program)",
  " (in 'twoterm_lmm', line 29, column 2 to column 17)",
  " (in 'twoterm_lmm', line 30, column 2 to column 28)",
  " (in 'twoterm_lmm', line 31, column 2 to column 28)",
  " (in 'twoterm_lmm', line 32, column 2 to column 28)",
  " (in 'twoterm_lmm', line 33, column 2 to column 24)",
  " (in 'twoterm_lmm', line 34, column 2 to column 24)",
  " (in 'twoterm_lmm', line 49, column 2 to column 19)",
  " (in 'twoterm_lmm', line 51, column 4 to column 107)",
  " (in 'twoterm_lmm', line 50, column 17 to line 52, column 3)",
  " (in 'twoterm_lmm', line 50, column 2 to line 52, column 3)",
  " (in 'twoterm_lmm', line 38, column 2 to column 36)",
  " (in 'twoterm_lmm', line 39, column 2 to column 42)",
  " (in 'twoterm_lmm', line 40, column 2 to column 46)",
  " (in 'twoterm_lmm', line 41, column 2 to column 46)",
  " (in 'twoterm_lmm', line 42, column 2 to column 63)",
  " (in 'twoterm_lmm', line 43, column 2 to column 63)",
  " (in 'twoterm_lmm', line 46, column 2 to column 68)",
  " (in 'twoterm_lmm', line 11, column 2 to column 17)",
  " (in 'twoterm_lmm', line 12, column 2 to column 17)",
  " (in 'twoterm_lmm', line 13, column 2 to column 17)",
  " (in 'twoterm_lmm', line 14, column 2 to column 17)",
  " (in 'twoterm_lmm', line 15, column 9 to column 10)",
  " (in 'twoterm_lmm', line 15, column 2 to column 14)",
  " (in 'twoterm_lmm', line 16, column 9 to column 10)",
  " (in 'twoterm_lmm', line 16, column 12 to column 13)",
  " (in 'twoterm_lmm', line 16, column 2 to column 17)",
  " (in 'twoterm_lmm', line 17, column 9 to column 10)",
  " (in 'twoterm_lmm', line 17, column 12 to column 13)",
  " (in 'twoterm_lmm', line 17, column 2 to column 18)",
  " (in 'twoterm_lmm', line 18, column 9 to column 10)",
  " (in 'twoterm_lmm', line 18, column 12 to column 13)",
  " (in 'twoterm_lmm', line 18, column 2 to column 18)",
  " (in 'twoterm_lmm', line 19, column 9 to column 10)",
  " (in 'twoterm_lmm', line 19, column 12 to column 13)",
  " (in 'twoterm_lmm', line 19, column 2 to column 18)",
  " (in 'twoterm_lmm', line 20, column 9 to column 10)",
  " (in 'twoterm_lmm', line 20, column 12 to column 13)",
  " (in 'twoterm_lmm', line 20, column 2 to column 18)",
  " (in 'twoterm_lmm', line 21, column 2 to column 17)",
  " (in 'twoterm_lmm', line 22, column 2 to column 24)",
  " (in 'twoterm_lmm', line 23, column 2 to column 17)",
  " (in 'twoterm_lmm', line 24, column 2 to column 15)",
  " (in 'twoterm_lmm', line 25, column 2 to column 16)",
  " (in 'twoterm_lmm', line 26, column 2 to column 15)",
  " (in 'twoterm_lmm', line 29, column 9 to column 10)",
  " (in 'twoterm_lmm', line 33, column 9 to column 10)",
  " (in 'twoterm_lmm', line 34, column 9 to column 10)",
  " (in 'twoterm_lmm', line 49, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_twoterm_lmm final : public model_base_crtp<model_twoterm_lmm> {
private:
  int N;
  int M;
  int P;
  int K;
  Eigen::Matrix<double,-1,1> Y_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  Eigen::Matrix<double,-1,-1> C1_data__;
  Eigen::Matrix<double,-1,-1> C2_data__;
  Eigen::Matrix<double,-1,-1> Z1_data__;
  Eigen::Matrix<double,-1,-1> Z2_data__;
  double coef_mean;
  double coef_sd;
  double sig2_mean;
  double sig2_sd;
  double sig2_loc;
  double sig2_sc;
  Eigen::Map<Eigen::Matrix<double,-1,1>> Y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> C1{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> C2{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Z1{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> Z2{nullptr, 0, 0};
public:
  ~model_twoterm_lmm() {}
  model_twoterm_lmm(stan::io::var_context& context__, unsigned int
                    random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_twoterm_lmm_namespace::model_twoterm_lmm";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 18;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 18;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "M", "int",
        std::vector<size_t>{});
      M = std::numeric_limits<int>::min();
      current_statement__ = 19;
      M = context__.vals_i("M")[(1 - 1)];
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "M", M, 0);
      current_statement__ = 20;
      context__.validate_dims("data initialization", "P", "int",
        std::vector<size_t>{});
      P = std::numeric_limits<int>::min();
      current_statement__ = 20;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 20;
      stan::math::check_greater_or_equal(function__, "P", P, 0);
      current_statement__ = 21;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 21;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 21;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 22;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 23;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      Y_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,1>>(Y_data__.data(), N);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 23;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 23;
        pos__ = 1;
        current_statement__ = 23;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 23;
          stan::model::assign(Y, Y_flat__[(pos__ - 1)],
            "assigning variable Y", stan::model::index_uni(sym1__));
          current_statement__ = 23;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 24;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 25;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, K);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 26;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 26;
        pos__ = 1;
        current_statement__ = 26;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 26;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 26;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 26;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 27;
      stan::math::validate_non_negative_index("C1", "M", M);
      current_statement__ = 28;
      stan::math::validate_non_negative_index("C1", "M", M);
      current_statement__ = 29;
      context__.validate_dims("data initialization", "C1", "double",
        std::vector<size_t>{static_cast<size_t>(M), static_cast<size_t>(M)});
      C1_data__ = Eigen::Matrix<double,-1,-1>::Constant(M, M,
                    std::numeric_limits<double>::quiet_NaN());
      new (&C1) Eigen::Map<Eigen::Matrix<double,-1,-1>>(C1_data__.data(), M,
        M);
      {
        std::vector<local_scalar_t__> C1_flat__;
        current_statement__ = 29;
        C1_flat__ = context__.vals_r("C1");
        current_statement__ = 29;
        pos__ = 1;
        current_statement__ = 29;
        for (int sym1__ = 1; sym1__ <= M; ++sym1__) {
          current_statement__ = 29;
          for (int sym2__ = 1; sym2__ <= M; ++sym2__) {
            current_statement__ = 29;
            stan::model::assign(C1, C1_flat__[(pos__ - 1)],
              "assigning variable C1", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 29;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 30;
      stan::math::validate_non_negative_index("C2", "P", P);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("C2", "P", P);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "C2", "double",
        std::vector<size_t>{static_cast<size_t>(P), static_cast<size_t>(P)});
      C2_data__ = Eigen::Matrix<double,-1,-1>::Constant(P, P,
                    std::numeric_limits<double>::quiet_NaN());
      new (&C2) Eigen::Map<Eigen::Matrix<double,-1,-1>>(C2_data__.data(), P,
        P);
      {
        std::vector<local_scalar_t__> C2_flat__;
        current_statement__ = 32;
        C2_flat__ = context__.vals_r("C2");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 32;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 32;
            stan::model::assign(C2, C2_flat__[(pos__ - 1)],
              "assigning variable C2", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 32;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 33;
      stan::math::validate_non_negative_index("Z1", "N", N);
      current_statement__ = 34;
      stan::math::validate_non_negative_index("Z1", "M", M);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "Z1", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(M)});
      Z1_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, M,
                    std::numeric_limits<double>::quiet_NaN());
      new (&Z1) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Z1_data__.data(), N,
        M);
      {
        std::vector<local_scalar_t__> Z1_flat__;
        current_statement__ = 35;
        Z1_flat__ = context__.vals_r("Z1");
        current_statement__ = 35;
        pos__ = 1;
        current_statement__ = 35;
        for (int sym1__ = 1; sym1__ <= M; ++sym1__) {
          current_statement__ = 35;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 35;
            stan::model::assign(Z1, Z1_flat__[(pos__ - 1)],
              "assigning variable Z1", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 35;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 36;
      stan::math::validate_non_negative_index("Z2", "N", N);
      current_statement__ = 37;
      stan::math::validate_non_negative_index("Z2", "P", P);
      current_statement__ = 38;
      context__.validate_dims("data initialization", "Z2", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(P)});
      Z2_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, P,
                    std::numeric_limits<double>::quiet_NaN());
      new (&Z2) Eigen::Map<Eigen::Matrix<double,-1,-1>>(Z2_data__.data(), N,
        P);
      {
        std::vector<local_scalar_t__> Z2_flat__;
        current_statement__ = 38;
        Z2_flat__ = context__.vals_r("Z2");
        current_statement__ = 38;
        pos__ = 1;
        current_statement__ = 38;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 38;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 38;
            stan::model::assign(Z2, Z2_flat__[(pos__ - 1)],
              "assigning variable Z2", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 38;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 39;
      context__.validate_dims("data initialization", "coef_mean", "double",
        std::vector<size_t>{});
      coef_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 39;
      coef_mean = context__.vals_r("coef_mean")[(1 - 1)];
      current_statement__ = 40;
      context__.validate_dims("data initialization", "coef_sd", "double",
        std::vector<size_t>{});
      coef_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      coef_sd = context__.vals_r("coef_sd")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "coef_sd", coef_sd, 0);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "sig2_mean", "double",
        std::vector<size_t>{});
      sig2_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      sig2_mean = context__.vals_r("sig2_mean")[(1 - 1)];
      current_statement__ = 42;
      context__.validate_dims("data initialization", "sig2_sd", "double",
        std::vector<size_t>{});
      sig2_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 42;
      sig2_sd = context__.vals_r("sig2_sd")[(1 - 1)];
      current_statement__ = 43;
      context__.validate_dims("data initialization", "sig2_loc", "double",
        std::vector<size_t>{});
      sig2_loc = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 43;
      sig2_loc = context__.vals_r("sig2_loc")[(1 - 1)];
      current_statement__ = 44;
      context__.validate_dims("data initialization", "sig2_sc", "double",
        std::vector<size_t>{});
      sig2_sc = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 44;
      sig2_sc = context__.vals_r("sig2_sc")[(1 - 1)];
      current_statement__ = 45;
      stan::math::validate_non_negative_index("Coef", "K", K);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("sp1_effects", "M", M);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("sp2_effects", "P", P);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("loglik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = K + 1 + 1 + 1 + M + P;
  }
  inline std::string model_name() const final {
    return "model_twoterm_lmm";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_twoterm_lmm_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      Coef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      local_scalar_t__ sigma_resid = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_resid = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      local_scalar_t__ sig2_scale1 = DUMMY_VAR__;
      current_statement__ = 3;
      sig2_scale1 = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      local_scalar_t__ sig2_scale2 = DUMMY_VAR__;
      current_statement__ = 4;
      sig2_scale2 = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> sp1_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M, DUMMY_VAR__);
      current_statement__ = 5;
      sp1_effects = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(M);
      Eigen::Matrix<local_scalar_t__,-1,1> sp2_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 6;
      sp2_effects = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      {
        current_statement__ = 11;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(Coef, coef_mean,
                         coef_sd));
        current_statement__ = 12;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma_resid,
                         sig2_loc, sig2_sc));
        current_statement__ = 13;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(sig2_scale1,
                         sig2_mean, sig2_sd));
        current_statement__ = 14;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(sig2_scale2,
                         sig2_mean, sig2_sd));
        current_statement__ = 15;
        lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(sp1_effects,
                         stan::math::rep_vector(0, M),
                         stan::math::multiply(sig2_scale1, C1)));
        current_statement__ = 16;
        lp_accum__.add(stan::math::multi_normal_lpdf<propto__>(sp2_effects,
                         stan::math::rep_vector(0, P),
                         stan::math::multiply(sig2_scale2, C2)));
        current_statement__ = 17;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(Y,
                         stan::math::add(
                           stan::math::add(stan::math::multiply(X, Coef),
                             stan::math::multiply(Z1, sp1_effects)),
                           stan::math::multiply(Z2, sp2_effects)),
                         sigma_resid));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_twoterm_lmm_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> Coef =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      Coef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      double sigma_resid = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma_resid = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      double sig2_scale1 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      sig2_scale1 = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      double sig2_scale2 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      sig2_scale2 = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> sp1_effects =
        Eigen::Matrix<double,-1,1>::Constant(M,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      sp1_effects = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(M);
      Eigen::Matrix<double,-1,1> sp2_effects =
        Eigen::Matrix<double,-1,1>::Constant(P,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      sp2_effects = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(P);
      out__.write(Coef);
      out__.write(sigma_resid);
      out__.write(sig2_scale1);
      out__.write(sig2_scale2);
      out__.write(sp1_effects);
      out__.write(sp2_effects);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> loglik =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 10;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 8;
        stan::model::assign(loglik,
          stan::math::normal_lpdf<false>(
            stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
            ((stan::math::multiply(
                stan::model::rvalue(X, "X", stan::model::index_uni(n)), Coef)
            +
            stan::math::multiply(
              stan::model::rvalue(Z1, "Z1", stan::model::index_uni(n)),
              sp1_effects)) +
            stan::math::multiply(
              stan::model::rvalue(Z2, "Z2", stan::model::index_uni(n)),
              sp2_effects)), sigma_resid), "assigning variable loglik",
          stan::model::index_uni(n));
      }
      out__.write(loglik);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(Coef,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable Coef");
      out__.write(Coef);
      local_scalar_t__ sigma_resid = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_resid = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_resid);
      local_scalar_t__ sig2_scale1 = DUMMY_VAR__;
      current_statement__ = 3;
      sig2_scale1 = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sig2_scale1);
      local_scalar_t__ sig2_scale2 = DUMMY_VAR__;
      current_statement__ = 4;
      sig2_scale2 = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sig2_scale2);
      Eigen::Matrix<local_scalar_t__,-1,1> sp1_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(sp1_effects,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(M),
        "assigning variable sp1_effects");
      out__.write(sp1_effects);
      Eigen::Matrix<local_scalar_t__,-1,1> sp2_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(sp2_effects,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(P),
        "assigning variable sp2_effects");
      out__.write(sp2_effects);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "Coef", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_resid",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sig2_scale1",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "sig2_scale2",
        "double", std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "sp1_effects",
        "double", std::vector<size_t>{static_cast<size_t>(M)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "sp2_effects",
        "double", std::vector<size_t>{static_cast<size_t>(P)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> Coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> Coef_flat__;
        current_statement__ = 1;
        Coef_flat__ = context__.vals_r("Coef");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(Coef, Coef_flat__[(pos__ - 1)],
            "assigning variable Coef", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(Coef);
      local_scalar_t__ sigma_resid = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_resid = context__.vals_r("sigma_resid")[(1 - 1)];
      out__.write_free_lb(0, sigma_resid);
      local_scalar_t__ sig2_scale1 = DUMMY_VAR__;
      current_statement__ = 3;
      sig2_scale1 = context__.vals_r("sig2_scale1")[(1 - 1)];
      out__.write_free_lb(0, sig2_scale1);
      local_scalar_t__ sig2_scale2 = DUMMY_VAR__;
      current_statement__ = 4;
      sig2_scale2 = context__.vals_r("sig2_scale2")[(1 - 1)];
      out__.write_free_lb(0, sig2_scale2);
      Eigen::Matrix<local_scalar_t__,-1,1> sp1_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sp1_effects_flat__;
        current_statement__ = 5;
        sp1_effects_flat__ = context__.vals_r("sp1_effects");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= M; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(sp1_effects, sp1_effects_flat__[(pos__ - 1)],
            "assigning variable sp1_effects", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(sp1_effects);
      Eigen::Matrix<local_scalar_t__,-1,1> sp2_effects =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(P, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sp2_effects_flat__;
        current_statement__ = 6;
        sp2_effects_flat__ = context__.vals_r("sp2_effects");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 6;
          stan::model::assign(sp2_effects, sp2_effects_flat__[(pos__ - 1)],
            "assigning variable sp2_effects", stan::model::index_uni(sym1__));
          current_statement__ = 6;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(sp2_effects);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"Coef", "sigma_resid", "sig2_scale1",
                "sig2_scale2", "sp1_effects", "sp2_effects"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"loglik"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(K)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(M)},
                std::vector<size_t>{static_cast<size_t>(P)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "Coef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_resid");
    param_names__.emplace_back(std::string() + "sig2_scale1");
    param_names__.emplace_back(std::string() + "sig2_scale2");
    for (int sym1__ = 1; sym1__ <= M; ++sym1__) {
      param_names__.emplace_back(std::string() + "sp1_effects" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "sp2_effects" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "loglik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "Coef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_resid");
    param_names__.emplace_back(std::string() + "sig2_scale1");
    param_names__.emplace_back(std::string() + "sig2_scale2");
    for (int sym1__ = 1; sym1__ <= M; ++sym1__) {
      param_names__.emplace_back(std::string() + "sp1_effects" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      param_names__.emplace_back(std::string() + "sp2_effects" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "loglik" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"Coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"sigma_resid\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sp1_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(M) + "},\"block\":\"parameters\"},{\"name\":\"sp2_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"Coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"sigma_resid\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale1\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sig2_scale2\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sp1_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(M) + "},\"block\":\"parameters\"},{\"name\":\"sp2_effects\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(P) + "},\"block\":\"parameters\"},{\"name\":\"loglik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((K + 1) + 1) + 1) + M) + P);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((K + 1) + 1) + 1) + M) + P);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * (N);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_twoterm_lmm_namespace::model_twoterm_lmm;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_twoterm_lmm_namespace::profiles__;
}
#endif
#endif
