% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.pres.R
\name{phylo.pres}
\alias{phylo.pres}
\title{Prepare rasters and phylogenetic tree to run community metrics}
\usage{
phylo.pres(x, tree, full_tree_metr = TRUE, ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species.}

\item{tree}{phylo. A dated tree.}

\item{full_tree_metr}{logical. Whether edge.path, branch length and number
of descendants should be calculated with the full (TRUE) or the prunned tree
(FALSE). The default is TRUE.}

\item{...}{additional arguments to be passed passed down from a calling
function.}
}
\value{
Returns a list containing a SpatRaster reordered according to the
order
that the species appear in the phylogenetic tree, a subtree containing only
the species that are in the stack of rasters and finally two named numerical
vectors containing the branch length and the number of descendants of
each species.
}
\description{
Reorder a stack of rasters of species distribution to
match the order
of the tips of the tree, and get branch length and number of descendants for
each species to calculate diversity metrics using phyloraster::geo.phylo().
The branch length and the number of descendants can be calculated based
on the full tree or the raster based tree subset. The names must be the
same in the phylogenetic tree and in the raster for the
same species. For example, if you have the name "Leptodactylus_latrans" in
the raster and "Leptodactylus latrans" in the tree, the function will not
work. The same goes for uppercase and lowercase letters.
}
\examples{
\donttest{
library(phyloraster)
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))
phylo.pres(x[[1:3]], tree, full_tree_metr = TRUE)

# using the prunned tree
phylo.pres(x[[1:3]], tree, full_tree_metr = FALSE)
}
}
\author{
Neander Marcel Heming and Gabriela Alves Ferreira
}
