% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_expected_links_obs_mtml.R
\name{translink_expected_links_obs_mtml}
\alias{translink_expected_links_obs_mtml}
\title{Calculate expected number of observed pairs assuming multiple-transmission and multiple-linkage}
\usage{
translink_expected_links_obs_mtml(specificity, sensitivity, rho, M, R)
}
\arguments{
\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the expected number of linked pairs observed in the sample
}
\description{
This function calculates the expected number of pairs observed in a sample of size \code{M}.
The multiple-transmission and multiple-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
\item Each case \eqn{i} is allowed to be linked by the linkage criteria to multiple cases \eqn{j} in the sampled population (\eqn{M}).
\item Linkage events are independent of one another (i.e, linkage of case \eqn{i} to case \eqn{j} has no bearing on linkage of case \eqn{i} to any other sample).
}
}
\examples{
# Perfect sensitivity and specificity
translink_expected_links_obs_mtml(sensitivity=1, specificity=1, rho=0.5, M=100, R=1)

translink_expected_links_obs_mtml(sensitivity=0.99, specificity=0.9, rho=1, M=50, R=1)

translink_expected_links_obs_mtml(sensitivity=0.99, specificity=0.9, rho=0.5, M=100, R=1)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl and Justin Lessler
}
\concept{transmission linkage functions}
