% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varfreq_obs_freq.R
\name{varfreq_obs_freq}
\alias{varfreq_obs_freq}
\title{Calculate observed variant prevalence}
\usage{
varfreq_obs_freq(p_v1, c_ratio)
}
\arguments{
\item{p_v1}{actual variant prevalence (proportion)}

\item{c_ratio}{coefficient of detection ratio, calculated as the ratio of the coefficients of variant 1 to variant 2}
}
\value{
scalar of observed prevalence of variant 1
}
\description{
This function calculates the observed variant prevalence from the coefficient of detection ratio
and the actual variant prevalence. This function assumes that variant 1 is the variant of concern.
This function is specific to the two-variant system.
}
\examples{
varfreq_obs_freq(p_v1 = 0.1, c_ratio = 1.1)

}
\seealso{
Other variant frequency functions: 
\code{\link{varfreq_cdf_logistic}()},
\code{\link{varfreq_expected_mbias}()},
\code{\link{varfreq_freq_logistic}()}
}
\author{
Shirlee Wohl, Elizabeth C. Lee, Bethany L. DiPrete, and Justin Lessler
}
\concept{variant frequency functions}
