% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exr-read.R
\name{read_exr}
\alias{read_exr}
\title{Read an EXR image}
\usage{
read_exr(filename, verbosity = 0)
}
\arguments{
\item{filename}{EXR filename or connection}

\item{verbosity}{Level of debugging output. Default: 0 (no debugging output)}
}
\value{
Numeric array with names along the third dimension.  Each plane in the
        array corresponds to a channel in the EXR.
}
\description{
Currently only single-part scanline images are supported (where the compression
is one of NONE, ZIP or ZIPS).
}
\examples{
filename <- system.file("image/rstats.exr", package = "picohdr")
images <- read_exr(filename)
dimnames(images)[[3]]

# Naively adjust one of the images for display
im <- adj_rescale(images[, , 'dzdy'], lo = 0, hi = 1)
plot(im)
}
