% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwchisq-.r
\name{pwchisq}
\alias{pwchisq}
\title{The Distribution of a Positive Linear Combination of Chiqaure Random Variables}
\usage{
pwchisq(x, lambda = 1, nu = 1, delta = 0, mode = 1,
  maxit1 = 1e+05, eps = 10^(-10))
}
\arguments{
\item{x}{numeric; value of x > 0 (\eqn{P[X \le x]}).}

\item{lambda}{numeric vector; weights (\eqn{\lambda_1, \ldots, \lambda_K}).}

\item{nu}{integer vector; degrees of freedom (\eqn{\nu_1, \ldots, \nu_K}).}

\item{delta}{numeric vector; non-centrality parameters (\eqn{\delta_1, \ldots, \delta_K}).}

\item{mode}{numeric; the mode of calculation (see Farabrother, 1984)}

\item{maxit1}{integer; the maximum number of iteration.}

\item{eps}{numeric; the desired level of accuracy.}
}
\value{
\itemize{
\item \code{prob}: the distribution function.
}
}
\description{
The cumulative distribution function for the distribution of a positive linear
combination of \eqn{\chi^2} random variables with the weights
(\eqn{\lambda_1, \ldots, \lambda_K}), degrees of freedom
(\eqn{\nu_1, \ldots, \nu_K}), and non-centrality parameters
(\eqn{\delta_1, \ldots, \delta_K}).
}
\examples{
# Table 1 of Farabrother (1984)
# Q6 (The taget values are 0.0061, 0.5913, and 0.9779)

pimeta::pwchisq( 20, lambda = c(7,3), nu = c(6,2), delta = c(6,2))
pimeta::pwchisq(100, lambda = c(7,3), nu = c(6,2), delta = c(6,2))
pimeta::pwchisq(200, lambda = c(7,3), nu = c(6,2), delta = c(6,2))
# [1] 0.006117973
# [1] 0.5913421
# [1] 0.9779184
}
\references{
Farebrother, R. W. (1984).
Algorithm AS 204: the distribution of a positive linear combination of
\eqn{\chi^2} random variables.
\emph{J R Stat Soc Ser C Appl Stat.}
\strong{33}(3): 332--339.
\url{https://rss.onlinelibrary.wiley.com/doi/10.2307/2347721}.
}
