% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DependencyReporter.R
\name{DependencyReporter}
\alias{DependencyReporter}
\title{Recursive Package Dependency Reporter}
\description{
This reporter looks at the recursive network of its dependencies
on other packages. This allows a developer to understand how individual
dependencies might lead to a much larger set of dependencies, potentially
informing decisions on including or removing them.
}
\examples{

## ------------------------------------------------
## Method `DependencyReporter$new`
## ------------------------------------------------

\donttest{

# Instantiate an object
reporter <- DependencyReporter$new()

# Seed it with a package
reporter$set_package("ggplot2")

}
}
\seealso{
Other Network Reporters: 
\code{\link{FunctionReporter}},
\code{\link{InheritanceReporter}}

Other Package Reporters: 
\code{\link{FunctionReporter}},
\code{\link{InheritanceReporter}},
\code{\link{SummaryReporter}}
}
\concept{Network Reporters}
\concept{Package Reporters}
\concept{Reporters}
\section{Super classes}{
\code{\link[pkgnet:AbstractPackageReporter]{pkgnet::AbstractPackageReporter}} -> \code{\link[pkgnet:AbstractGraphReporter]{pkgnet::AbstractGraphReporter}} -> \code{DependencyReporter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{report_markdown_path}}{(character string) path to R Markdown template for this reporter. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DependencyReporter-new}{\code{DependencyReporter$new()}}
\item \href{#method-DependencyReporter-clone}{\code{DependencyReporter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractPackageReporter" data-id="set_package"><a href='../../pkgnet/html/AbstractPackageReporter.html#method-AbstractPackageReporter-set_package'><code>pkgnet::AbstractPackageReporter$set_package()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraphReporter" data-id="calculate_default_measures"><a href='../../pkgnet/html/AbstractGraphReporter.html#method-AbstractGraphReporter-calculate_default_measures'><code>pkgnet::AbstractGraphReporter$calculate_default_measures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraphReporter" data-id="get_summary_view"><a href='../../pkgnet/html/AbstractGraphReporter.html#method-AbstractGraphReporter-get_summary_view'><code>pkgnet::AbstractGraphReporter$get_summary_view()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyReporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyReporter-new}{}}}
\subsection{Method \code{new()}}{
Initialize an instance of the reporter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyReporter$new(
  dep_types = c("Imports", "Depends", "LinkingTo"),
  installed = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dep_types}}{(character vector) The sections within the \code{DESCRIPTION} file to be counted as dependencies. 
By default, c("Imports", "Depends", "LinkingTo") is chosen.}

\item{\code{installed}}{(logical) If \code{TRUE}, consider only installed packages when building dependency network.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{

# Instantiate an object
reporter <- DependencyReporter$new()

# Seed it with a package
reporter$set_package("ggplot2")

}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DependencyReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DependencyReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DependencyReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
