% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_map.R
\name{b_map}
\alias{b_map}
\title{Plots a heatmap of b-score normalised values in a plate layout}
\usage{
b_map(
  data,
  well,
  normalise = FALSE,
  plate = 96,
  eps = 0.01,
  maxiter = 10,
  trace.iter = FALSE,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{data}{Numerical values in the form of a vector to be normalised}

\item{well}{Vector of well identifiers, e.g "A01"}

\item{normalise}{Boolean, if TRUE then the residual values will be divded by
the plate median absolute deviation as per Malo et al.}

\item{plate}{integer, 6, 12, 24, 48, 96, 384 or 1536}

\item{eps}{real number greater than 0. A tolerance for divergence}

\item{maxiter}{int, the maximum number of iterations}

\item{trace.iter}{Boolean, should progress in convergence be reported?}

\item{na.rm}{Boolean, should missing values be removed?}

\item{...}{additional parameters to plot wrappers}
}
\value{
ggplot plot
}
\description{
Transforms numerical values using the b-score normalisation process to account
for row and column effects. Uses well labels to plot the normalised values in
the form of a microtitre plate. Works for 6, 12, 24, 48, 96, 384 or 1536 well plates
}
\examples{
df <- data.frame(well = num_to_well(1:96),
vals = rnorm(96))

b_map(data = df$vals,
     well = df$well,
     plate = 96)

df_384 <- data.frame(
         well = num_to_well(1:384, plate = 384),
         vals = rnorm(384))

b_map(data = df_384$vals,
     well = df_384$well,
     plate = 384)
}
