% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_to_well.R
\name{num_to_well}
\alias{num_to_well}
\title{Converts numbers to well labels}
\usage{
num_to_well(x, plate = 96)
}
\arguments{
\item{x}{Vector of numbers to be converted}

\item{plate}{Number of wells in complete plate (96 or 384)}
}
\value{
Vector of alpha-numeric well labels
}
\description{
Converts numerical values to corresponding alpha-numeric well labels
for 6, 12, 24, 48, 96, 384 or 1536 well plates.
Note, it's advisable to specify the number of wells in `plate`.
}
\examples{
num_to_well(1:96)
num_to_well(1:96, plate = 384)

nums <- c(1:10, 20:40, 60:96)
num_to_well(nums)
}
