% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hangman.R
\name{play_hangman}
\alias{play_hangman}
\alias{hangman}
\title{Play a game of hangman in the console}
\source{
The default word list is derived from
\href{http://wordlist.aspell.net/12dicts/}{12dicts} created by
\href{http://www.wyrdplay.org/}{Alan Beale}.

This word list is passed through the
\href{https://www.cs.cmu.edu/~biglou/resources/}{Offensive/Profane Word List}
created by \href{https://www.cs.cmu.edu/~biglou/}{Luis Von Ahn} to filter out
potentially unwanted words.
}
\usage{
play_hangman(
  difficulty = c("beginner", "easy", "medium", "hard", "expert"),
  word_list = NULL
)
}
\arguments{
\item{difficulty}{Determines the length of words used for the game and,
if \code{word_list} is \code{NULL}, how common the words are}

\item{word_list}{Optionally, a character vector of words used to play the
game.
If unspecified, a default word list will be used based on \code{difficulty}.}
}
\value{
Generates interactive output in the console.
}
\description{
Play a game of hangman in the console
}
\section{Problematic words?}{
You can report any words you find objectionable to
\url{https://github.com/rossellhayes/hangman/issues}.

Please report:
\itemize{
\item offensive words
\item words that deal with uncomfortable topics
\item proper nouns
\item text that is not a common English word
}
}

\examples{
play_hangman()

play_hangman("beginner")
play_hangman("easy")
play_hangman("medium")
play_hangman("hard")
play_hangman("expert")

cars <- unique(gsub(" .*", "", rownames(mtcars)))
play_hangman(word_list = cars)
}
