% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_segmentation.R
\name{dist_transform}
\alias{dist_transform}
\title{Distance map transform}
\usage{
dist_transform(binary)
}
\arguments{
\item{binary}{A binary image}
}
\value{
An \code{Image} object or an array, with pixels containing the distances
to the nearest background points
}
\description{
Computes the distance map transform of a binary image. The distance map is a
matrix which contains for each pixel the distance to its nearest background
pixel.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("soybean_touch.jpg")
binary <- image_binary(img, "B")[[1]]
wts <- dist_transform(binary)
range(wts)
}
}
