% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed.R
\name{readVID}
\alias{readVID}
\title{read variant ID}
\usage{
readVID(bim, opt = NULL, vfr = NULL, vto = NULL)
}
\arguments{
\item{bim}{prefix or name of a PLINK file, or data frame from a BIM file.}

\item{opt}{option (def=1: the 2nd column in BIM file).}

\item{vfr}{variant-wise, from where to read? (index/proportion, def=1).}

\item{vto}{varinat-wise, to where then stop? (index/proportion, def=P).}
}
\value{
a vector of variant ID
}
\description{
Generate variant ID automatically, or based on a \emph{bim} file.
}
\details{
The option (\code{opt}) can be:
\itemize{
\item 1 = the 2nd column in \emph{pfx}.bim (default),
\item 2 = formated as \%CHR(02d):\%BPS(09d),
\item 3 = formated as \%CHR(02d):\%BPS(09d)_AL1(s)_AL2(s)
\item 0 = nothing
\item -1 = numbering of variants, decimal
\item -2 = numbering of variants, zero-padded, fixed length decimal
\item -3 = numbering of variants, zero-padded, fixed length hexedemical
\item or, a vector of IDs to use.
}
}
\examples{
# read variant ID
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20")

# opt=1: 2nd column in the BED file (default)
vid <- readVID(pfx, 1); head(vid); tail(vid)

# opt=2: format by position
vid <- readVID(pfx, 2); head(vid); tail(vid)

# opt=3: format by position and alleles
vid <- readVID(pfx, 3); head(vid); tail(vid)

# opt=-1: number sequence
vid <- readVID(pfx, -1); head(vid); tail(vid)

# opt=-2: number sequence, fixed length, decimal
vid <- readVID(pfx, -2); head(vid); tail(vid)

# opt=-3: number sequence, fixed length, hexidemical
vid <- readVID(pfx, -3); head(vid); tail(vid)
}
