% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startvals.R
\name{startalphas}
\alias{startalphas}
\alias{startbetas}
\title{Starting values for polytomous logit-normit model}
\usage{
startalphas(x, ncat, nitem = NULL)
startbetas(x, ncat, nitem = NULL)
}
\arguments{
\item{x}{A data matrix. Data can be in one of two formats: 1) raw data
where the number of rows corresponds to the number of raw cases and
each column represents an item, and 2) a matrix of dimensions
\code{nrec}\eqn{\times}{X}(\code{nitem}+1) where each row corresponds to a
response pattern and the last column is the frequency of that response
pattern. A data matrix of the second type requires input for \code{nitem}
and \code{nrec}.}

\item{ncat}{Number of ordinal categories for each item, coded as
0,\dots,(\code{ncat}-1). Currently supported are items that have the same number of categories.}

\item{nitem}{Number of items. If omitted, it is assumed that \code{x} contains
a data matrix of the first type (raw data) and the number of
columns in \code{x} will be selected as the number of items.}
}
\value{
A vector of starting values, depending on which function was called.
}
\description{
Computes starting values for estimation of polytomous logit-normit model.
}
\details{
\code{startalphas} computes starting values for the (decreasing) cutpoints
  for the items based on logit transformed probabilities, assuming independent items.

  \code{startbetas} computes starting values for slopes under the polytomous
  logit-normit model, using a method based on values that are proportional to the
  average correlations of each item with all other items. Starting values are
  currently bounded between -.2 and 1.
}
\examples{
### Raw data
data(item9cat5)

myAlphas<-startalphas(item9cat5, ncat=5)
print(myAlphas)

myBetas<-startbetas(item9cat5, ncat=5)
print(myBetas)

nrbcplnout<-nrbcpln(item9cat5, ncat=5, alphas=myAlphas, betas=myBetas, se=FALSE)
print(nrbcplnout)

## Matrix of response patterns and frequencies
data(item5fr)

myAlphas<-startalphas(item5fr, ncat=3, nitem=5)
print(myAlphas)

myBetas<-startbetas(item5fr, ncat=3, nitem=5)
print(myBetas)

nrbcplnout<-nrbcpln(item5fr, ncat=3, nitem=5, alphas=myAlphas, betas=myBetas, se=FALSE)
print(nrbcplnout)
  
}
\seealso{
\code{\link{nrmlepln}}
 \code{\link{nrmlerasch}}
 \code{\link{nrbcpln}}
}
\author{
Carl F. Falk \email{cffalk@gmail.com}, Harry Joe
}
