% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{Plan}
\alias{Plan}
\title{R6 Class for Planning and Executing Analyses}
\description{
The \code{Plan} class provides a framework for organizing and executing multiple analyses
on one or more datasets. It enforces a structured approach to analysis by:
\enumerate{
\item \strong{Data Management}:
\itemize{
\item Loading data once and reusing across analyses
\item Separating data cleaning from analysis
\item Providing hash-based tracking of data changes
}
\item \strong{Analysis Structure}:
\itemize{
\item Requiring all analyses to use the same data sources
\item Standardizing analysis functions to accept only \code{data} and \code{argset} parameters
\item Organizing analyses into clear, maintainable plans
}
\item \strong{Execution Control}:
\itemize{
\item Supporting both single-function and multi-function analysis plans
\item Providing flexible execution options (sequential or parallel)
\item Including built-in debugging tools
}
}
}
\details{
The framework uses three main concepts:
\itemize{
\item \strong{Argset}: A named list containing a set of arguments for an analysis
\item \strong{Analysis}: A combination of one argset and one action function
\item \strong{Plan}: A container that holds one data pull and a list of analyses
}
}
\examples{

## ------------------------------------------------
## Method `Plan$add_data`
## ------------------------------------------------

p <- plnr::Plan$new()

# Add data using a function
data_fn <- function() { return(plnr::nor_covid19_cases_by_time_location) }
p$add_data("data_1", fn = data_fn)

# Add data using a function name
p$add_data("data_2", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Add data directly
p$add_data("data_3", direct = plnr::nor_covid19_cases_by_time_location)

# View added data
p$get_data()

## ------------------------------------------------
## Method `Plan$add_argset`
## ------------------------------------------------

p <- plnr::Plan$new()

# Add argsets with different arguments
p$add_argset("argset_1", var_1 = 3, var_b = "hello")
p$add_argset("argset_2", var_1 = 8, var_c = "hello2")

# View added argsets
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_argset_from_df`
## ------------------------------------------------

p <- plnr::Plan$new()

# Create data frame of argsets
batch_argset_df <- data.frame(
  name = c("a", "b", "c"),
  var_1 = c(1, 2, 3),
  var_2 = c("i", "j", "k")
)

# Add argsets from data frame
p$add_argset_from_df(batch_argset_df)

# View added argsets
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_argset_from_list`
## ------------------------------------------------

p <- plnr::Plan$new()

# Create list of argsets
batch_argset_list <- list(
  list(name = "a", var_1 = 1, var_2 = "i"),
  list(name = "b", var_1 = 2, var_2 = "j"),
  list(name = "c", var_1 = 3, var_2 = "k")
)

# Add argsets from list
p$add_argset_from_list(batch_argset_list)

# View added argsets
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_analysis`
## ------------------------------------------------

p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Add analysis
p$add_analysis(
  name = "analysis_1",
  fn_name = "plnr::example_action_fn"
)

# View argsets and run analysis
p$get_argsets_as_dt()
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$add_analysis_from_df`
## ------------------------------------------------

p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Create data frame of analyses
batch_argset_df <- data.frame(
  name = c("a", "b", "c"),
  var_1 = c(1, 2, 3),
  var_2 = c("i", "j", "k")
)

# Add analyses from data frame
p$add_analysis_from_df(
  fn_name = "plnr::example_action_fn",
  df = batch_argset_df
)

# View argsets and run example
p$get_argsets_as_dt()
p$run_one(1)

## ------------------------------------------------
## Method `Plan$add_analysis_from_list`
## ------------------------------------------------

p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Create list of analyses
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)

# Add analyses from list
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)

# View argsets and run example
p$get_argsets_as_dt()
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$get_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
p$get_data()

## ------------------------------------------------
## Method `Plan$get_analysis`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_analysis("analysis_1")

## ------------------------------------------------
## Method `Plan$get_argset`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argset("analysis_1")

## ------------------------------------------------
## Method `Plan$get_argsets_as_dt`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$run_one_with_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_one_with_data("analysis_1", data)

## ------------------------------------------------
## Method `Plan$run_one`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$run_all_with_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_all_with_data(data)

## ------------------------------------------------
## Method `Plan$run_all`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all()

## ------------------------------------------------
## Method `Plan$run_all_progress`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all_progress()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{analyses}}{List of analyses, each containing an argset and action function}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Plan-new}{\code{Plan$new()}}
\item \href{#method-Plan-add_data}{\code{Plan$add_data()}}
\item \href{#method-Plan-add_argset}{\code{Plan$add_argset()}}
\item \href{#method-Plan-add_argset_from_df}{\code{Plan$add_argset_from_df()}}
\item \href{#method-Plan-add_argset_from_list}{\code{Plan$add_argset_from_list()}}
\item \href{#method-Plan-add_analysis}{\code{Plan$add_analysis()}}
\item \href{#method-Plan-add_analysis_from_df}{\code{Plan$add_analysis_from_df()}}
\item \href{#method-Plan-add_analysis_from_list}{\code{Plan$add_analysis_from_list()}}
\item \href{#method-Plan-apply_action_fn_to_all_argsets}{\code{Plan$apply_action_fn_to_all_argsets()}}
\item \href{#method-Plan-apply_analysis_fn_to_all}{\code{Plan$apply_analysis_fn_to_all()}}
\item \href{#method-Plan-x_length}{\code{Plan$x_length()}}
\item \href{#method-Plan-x_seq_along}{\code{Plan$x_seq_along()}}
\item \href{#method-Plan-set_progress}{\code{Plan$set_progress()}}
\item \href{#method-Plan-set_progressor}{\code{Plan$set_progressor()}}
\item \href{#method-Plan-set_verbose}{\code{Plan$set_verbose()}}
\item \href{#method-Plan-set_use_foreach}{\code{Plan$set_use_foreach()}}
\item \href{#method-Plan-get_data}{\code{Plan$get_data()}}
\item \href{#method-Plan-get_analysis}{\code{Plan$get_analysis()}}
\item \href{#method-Plan-get_argset}{\code{Plan$get_argset()}}
\item \href{#method-Plan-get_argsets_as_dt}{\code{Plan$get_argsets_as_dt()}}
\item \href{#method-Plan-run_one_with_data}{\code{Plan$run_one_with_data()}}
\item \href{#method-Plan-run_one}{\code{Plan$run_one()}}
\item \href{#method-Plan-run_all_with_data}{\code{Plan$run_all_with_data()}}
\item \href{#method-Plan-run_all}{\code{Plan$run_all()}}
\item \href{#method-Plan-run_all_progress}{\code{Plan$run_all_progress()}}
\item \href{#method-Plan-run_all_parallel}{\code{Plan$run_all_parallel()}}
\item \href{#method-Plan-clone}{\code{Plan$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-new"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-new}{}}}
\subsection{Method \code{new()}}{
Create a new Plan instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$new(verbose = interactive() | config$force_verbose, use_foreach = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical, whether to show verbose output. Defaults to TRUE in interactive mode
or when config$force_verbose is TRUE}

\item{\code{use_foreach}}{Logical, whether to use foreach for parallel processing.
NULL = program decides, FALSE = use loop, TRUE = use foreach}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new Plan instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_data}{}}}
\subsection{Method \code{add_data()}}{
Add a new dataset to the plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_data(name, fn = NULL, fn_name = NULL, direct = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character string, name of the dataset}

\item{\code{fn}}{Function that returns the dataset (optional)}

\item{\code{fn_name}}{Character string, name of a function that returns the dataset (optional)}

\item{\code{direct}}{Direct dataset object (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Add data using a function
data_fn <- function() { return(plnr::nor_covid19_cases_by_time_location) }
p$add_data("data_1", fn = data_fn)

# Add data using a function name
p$add_data("data_2", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Add data directly
p$add_data("data_3", direct = plnr::nor_covid19_cases_by_time_location)

# View added data
p$get_data()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_argset"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_argset}{}}}
\subsection{Method \code{add_argset()}}{
Add a new argset to the plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset(name = uuid::UUIDgenerate(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character string, name of the argset (defaults to a UUID)}

\item{\code{...}}{Named arguments that will comprise the argset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Add argsets with different arguments
p$add_argset("argset_1", var_1 = 3, var_b = "hello")
p$add_argset("argset_2", var_1 = 8, var_c = "hello2")

# View added argsets
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_argset_from_df"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_argset_from_df}{}}}
\subsection{Method \code{add_argset_from_df()}}{
Add multiple argsets from a data frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset_from_df(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{Data frame where each row represents a new argset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Create data frame of argsets
batch_argset_df <- data.frame(
  name = c("a", "b", "c"),
  var_1 = c(1, 2, 3),
  var_2 = c("i", "j", "k")
)

# Add argsets from data frame
p$add_argset_from_df(batch_argset_df)

# View added argsets
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_argset_from_list"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_argset_from_list}{}}}
\subsection{Method \code{add_argset_from_list()}}{
Add multiple argsets from a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset_from_list(l)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{l}}{List of lists, where each inner list represents a new argset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Create list of argsets
batch_argset_list <- list(
  list(name = "a", var_1 = 1, var_2 = "i"),
  list(name = "b", var_1 = 2, var_2 = "j"),
  list(name = "c", var_1 = 3, var_2 = "k")
)

# Add argsets from list
p$add_argset_from_list(batch_argset_list)

# View added argsets
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_analysis}{}}}
\subsection{Method \code{add_analysis()}}{
Add a new analysis to the plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis(name = uuid::UUIDgenerate(), fn = NULL, fn_name = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character string, name of the analysis (defaults to a UUID)}

\item{\code{fn}}{Function to use for the analysis (optional)}

\item{\code{fn_name}}{Character string, name of the function to use (optional)}

\item{\code{...}}{Additional arguments to be added to the argset}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Add analysis
p$add_analysis(
  name = "analysis_1",
  fn_name = "plnr::example_action_fn"
)

# View argsets and run analysis
p$get_argsets_as_dt()
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_analysis_from_df"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_analysis_from_df}{}}}
\subsection{Method \code{add_analysis_from_df()}}{
Add multiple analyses from a data frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis_from_df(fn = NULL, fn_name = NULL, df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Function to use for all analyses (optional)}

\item{\code{fn_name}}{Character string, name of the function to use (optional)}

\item{\code{df}}{Data frame where each row represents a new analysis}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Create data frame of analyses
batch_argset_df <- data.frame(
  name = c("a", "b", "c"),
  var_1 = c(1, 2, 3),
  var_2 = c("i", "j", "k")
)

# Add analyses from data frame
p$add_analysis_from_df(
  fn_name = "plnr::example_action_fn",
  df = batch_argset_df
)

# View argsets and run example
p$get_argsets_as_dt()
p$run_one(1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-add_analysis_from_list"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-add_analysis_from_list}{}}}
\subsection{Method \code{add_analysis_from_list()}}{
Add multiple analyses from a list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis_from_list(fn = NULL, fn_name = NULL, l)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Function to use for all analyses (optional)}

\item{\code{fn_name}}{Character string, name of the function to use (optional)}

\item{\code{l}}{List of lists, where each inner list represents a new analysis}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, modifies the plan in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()

# Add example data
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")

# Create list of analyses
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)

# Add analyses from list
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)

# View argsets and run example
p$get_argsets_as_dt()
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-apply_action_fn_to_all_argsets"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-apply_action_fn_to_all_argsets}{}}}
\subsection{Method \code{apply_action_fn_to_all_argsets()}}{
Applies an action function to all the argsets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$apply_action_fn_to_all_argsets(fn = NULL, fn_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.
p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
list(name = "analysis_1", var_1 = 1, var_2 = "i"),
list(name = "analysis_2", var_1 = 2, var_2 = "j"),
list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_argset_from_list(
fn_name = "plnr::example_action_fn",
l = batch_argset_list
)
p$get_argsets_as_dt()
p$apply_action_fn_to_all_argsets(fn_name = "plnr::example_action_fn")
p$run_one("analysis_1")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-apply_analysis_fn_to_all"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-apply_analysis_fn_to_all}{}}}
\subsection{Method \code{apply_analysis_fn_to_all()}}{
Deprecated. Use apply_action_fn_to_all_argsets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$apply_analysis_fn_to_all(fn = NULL, fn_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-x_length"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-x_length}{}}}
\subsection{Method \code{x_length()}}{
Number of analyses in the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$x_length()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-x_seq_along"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-x_seq_along}{}}}
\subsection{Method \code{x_seq_along()}}{
Generate a regular sequence from 1 to the length of the analyses in the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$x_seq_along()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-set_progress"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-set_progress}{}}}
\subsection{Method \code{set_progress()}}{
Set an internal progress bar
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_progress(pb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pb}}{Progress bar.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-set_progressor"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-set_progressor}{}}}
\subsection{Method \code{set_progressor()}}{
Set an internal progressor progress bar
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_progressor(pb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pb}}{progressor progress bar.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-set_verbose"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-set_verbose}{}}}
\subsection{Method \code{set_verbose()}}{
Set verbose flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_verbose(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Boolean.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-set_use_foreach"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-set_use_foreach}{}}}
\subsection{Method \code{set_use_foreach()}}{
Set use_foreach flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_use_foreach(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Boolean.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-get_data}{}}}
\subsection{Method \code{get_data()}}{
Extracts the data provided via 'add_data' and returns it as a named list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list, where most elements have been added via \code{add_data}.

One extra named element is called 'hash'. 'hash' contains the data hashes of particular datasets/variables, as calculated using the 'spookyhash' algorithm via digest::digest.
'hash' contains two named elements:
\itemize{
\item current (the hash of the entire named list)
\item current_elements (the hash of the named elements within the named list)
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
p$get_data()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-get_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-get_analysis}{}}}
\subsection{Method \code{get_analysis()}}{
Extracts an analysis from the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_analysis(index_analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An analysis.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_analysis("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-get_argset"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-get_argset}{}}}
\subsection{Method \code{get_argset()}}{
Extracts an argset from the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_argset(index_analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An argset
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argset("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-get_argsets_as_dt"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-get_argsets_as_dt}{}}}
\subsection{Method \code{get_argsets_as_dt()}}{
Gets all argsets and presents them as a data.table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_argsets_as_dt()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data.table that contains all the argsets within a plan.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_one_with_data"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_one_with_data}{}}}
\subsection{Method \code{run_one_with_data()}}{
Run one analysis (data is provided by user).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_one_with_data(index_analysis, data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}

\item{\code{data}}{Named list (generally obtained from p$get_data()).}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_one_with_data("analysis_1", data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_one"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_one}{}}}
\subsection{Method \code{run_one()}}{
Run one analysis (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_one(index_analysis, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_all_with_data"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_all_with_data}{}}}
\subsection{Method \code{run_all_with_data()}}{
Run all analyses (data is provided by user).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all_with_data(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Named list (generally obtained from p$get_data()).}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_all_with_data(data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_all"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_all}{}}}
\subsection{Method \code{run_all()}}{
Run all analyses (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_all_progress"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_all_progress}{}}}
\subsection{Method \code{run_all_progress()}}{
Run all analyses with a progress bar (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all_progress(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_nor_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all_progress()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-run_all_parallel"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-run_all_parallel}{}}}
\subsection{Method \code{run_all_parallel()}}{
Run all analyses in parallel (data is obtained automatically from self$get_data()).

This function only works on linux computers and uses \code{pbmcapply} as the parallel backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all_parallel(mc.cores = getOption("mc.cores", 2L), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mc.cores}}{Number of cores to be used.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Plan-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Plan-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
