% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ATE.R
\name{plot_CATE}
\alias{plot_CATE}
\title{Plot the histogram or density of the Conditional Average Treatment Effect}
\usage{
plot_CATE(
  .model,
  type = c("histogram", "density"),
  ci_80 = FALSE,
  ci_95 = FALSE,
  reference = NULL,
  .mean = FALSE,
  .median = FALSE
)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{type}{histogram or density}

\item{ci_80}{TRUE/FALSE. Show the 80\% credible interval?}

\item{ci_95}{TRUE/FALSE. Show the 95\% credible interval?}

\item{reference}{numeric. Show a vertical reference line at this value}

\item{.mean}{TRUE/FALSE. Show the mean reference line}

\item{.median}{TRUE/FALSE. Show the median reference line}
}
\value{
ggplot object
}
\description{
Plot the conditional average treatment effect (CATE) of a 'bartCause' model.
The conditional average treatment effect is derived from taking the difference between
predictions for each individual under the control condition and under the treatment condition averaged over the population.
Means of the CATE distribution will resemble SATE and PATE but the CATE distribution accounts for more uncertainty than SATE and less uncertainty than PATE.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSup.rule = 'none'
)
plot_CATE(model_results)
}
}
\author{
George Perrett, Joseph Marlo
}
