% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moderators.R
\name{plot_moderator_search}
\alias{plot_moderator_search}
\title{Plot a single regression tree of covariates on ICATEs}
\usage{
plot_moderator_search(.model, max_depth = c(2, 1, 3))
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}

\item{max_depth}{one of c(1, 2, 3). Maximum number of node levels within the tree. 2 is recommended}
}
\value{
ggplot object
}
\description{
Plot a single regression tree for exploratory heterogeneous effects. Fit single regression tree on bartc() ICATEs to produce variable importance plot. This plot is useful for identifying potential moderating variables.
Tree depth may be set to depths 1, 2 or 3. Terminal nodes signal the Conditional Average Treatment effect within levels of moderation variables. Trees with different values across terminal nodes suggest strong treatment effect moderation.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSuprule = 'none'
)
plot_moderator_search(model_results)
}
}
\author{
George Perrett, Joseph Marlo
}
