% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trace.R
\name{plot_trace}
\alias{plot_trace}
\title{Trace plot the estimands of a `bartCause::bartc()` model}
\usage{
plot_trace(.model)
}
\arguments{
\item{.model}{a model produced by `bartCause::bartc()`}
}
\value{
ggplot object
}
\description{
Returns a ggplot of the estimated effect over each iteration of the model fit. This is used to visually assess the convergence of Markov chain Monte Carlo (MCMC) sampling. Chains should be well mixed such that no single color is notably separate from others.
}
\examples{
\donttest{
data(lalonde)
confounders <- c('age', 'educ', 'black', 'hisp', 'married', 'nodegr')
model_results <- bartCause::bartc(
 response = lalonde[['re78']],
 treatment = lalonde[['treat']],
 confounders = as.matrix(lalonde[, confounders]),
 estimand = 'ate',
 commonSup.rule = 'none'
)
plot_trace(.model = model_results)
}
}
\author{
Joseph Marlo, George Perrett
}
