% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rocci.R
\docType{data}
\name{geom_rocci}
\alias{geom_rocci}
\alias{GeomRocci}
\title{Confidence regions for the ROC curve}
\format{
An object of class \code{GeomRocci} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 6.
}
\usage{
geom_rocci(
  mapping = NULL,
  data = NULL,
  stat = "rocci",
  ci.at = NULL,
  sig.level = 0.05,
  na.rm = TRUE,
  alpha.box = 0.3,
  labels = TRUE,
  labelsize = 3.88,
  labelround = 1,
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

GeomRocci
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_rocci} and \code{stat_rocci}.}

\item{ci.at}{Vector of values in the range of the biomarker where confidence regions will be displayed}

\item{sig.level}{Significance level for the confidence regions}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{alpha.box}{Alpha level for the confidence regions}

\item{labels}{If TRUE, adds text labels for the cutoffs where the confidence regions are displayed}

\item{labelsize}{Size of cutoff text labels}

\item{labelround}{Integer, number of significant digits to round cutoff labels}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If FALSE, overrides the default aesthetics, rather than combining with them.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}
}
\description{
Display rectangular confidence regions for the empirical ROC curve.
}
\section{Aesthetics}{

\code{geom_rocci} understands the following aesthetics (required aesthetics
are in bold). \code{stat_rocci} automatically maps the estimates to the required aesthetics:
\itemize{
  \item \strong{\code{x}} The FPF estimate
  \item \strong{\code{y}} The TPF estimate
  \item \strong{\code{xmin}} Lower confidence limit for the FPF
  \item \strong{\code{xmax}} Upper confidence limit for the FPF
  \item \strong{\code{ymin}} Lower confidence limit for the TPF
  \item \strong{\code{ymax}} Upper confidence limit for the TPF
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\examples{

D.ex <- rbinom(50, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(50, mean = D.ex, sd = .4), rnorm(50, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 50), rep("B", 50)))

ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + geom_rocci()
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci()
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci(sig.level = .01)
ggplot(rocdata, aes(m = M, d = D)) + geom_roc(n.cuts = 0) + 
geom_rocci(ci.at = quantile(rocdata$M, c(.1, .25, .5, .75, .9)))
ggplot(rocdata, aes(m = M, d = D, color = Z)) + geom_roc() + geom_rocci(linetype = 1)
}
\seealso{
See \code{\link{geom_roc}} for the empirical ROC curve, \code{\link{style_roc}} for 
  adding guidelines and labels, and \code{\link{direct_label}} for adding direct labels to the 
  curves. Also \link{export_interactive_roc} for creating interactive ROC curve plots for use in a web browser.
}
\keyword{datasets}
