% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcli_wrappers.r
\name{plotcli_histogram}
\alias{plotcli_histogram}
\title{Histogram plot using plotcli}
\usage{
plotcli_histogram(
  x,
  plot_width = getOption("plotcli.plot_width", 80),
  plot_height = getOption("plotcli.plot_height", 40),
  x_label = "x",
  y_label = "Frequency",
  color = NULL,
  braille = getOption("plotcli.braille", TRUE),
  bin_width = NULL,
  ylim = NULL,
  name = "histogram",
  ...
)
}
\arguments{
\item{x}{A numeric vector of values}

\item{plot_width}{Width of the plot (default: 80)}

\item{plot_height}{Height of the plot (default: 40)}

\item{x_label}{Label for the x-axis (default: "x")}

\item{y_label}{Label for the y-axis (default: "Frequency")}

\item{color}{Color of the plot elements (default: NULL)}

\item{braille}{Use Braille characters for the plot (default: TRUE)}

\item{bin_width}{Width of the bins (default: NULL)}

\item{ylim}{y limits (default: NULL)}

\item{name}{Name of the plot element (default: "histogram")}

\item{...}{Additional arguments passed to the plotcli$new() function}
}
\description{
Create a histogram plot using plotcli. Short alias: \code{pclih}.
}
\examples{
x <- rnorm(100)
plotcli_histogram(x)
}
