% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plug.R
\name{plug_download_base}
\alias{plug_download_base}
\title{Download all data from a specific base}
\usage{
plug_download_base(
  base_name,
  endpoint = "https://plug.der.pe.gov.br/MadrixApi/executeQuery",
  verbosity = 0
)
}
\arguments{
\item{base_name}{The name of the base from which to download all data.}

\item{endpoint}{The endpoint URL for executing queries.}

\item{verbosity}{The verbosity level of the API request (0 = none, 1 = minimal, 2 = detailed).}
}
\value{
A tibble containing all data from the specified base.
}
\description{
This function downloads all data from a specified base using the query \verb{SELECT * FROM base_name}.
}
\examples{
\donttest{
\dontrun{
data <- plug_download_base(
  base_name = "Contratos_VIEW"
)
}
}
}
