% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sim_dat}
\alias{sim_dat}
\title{Simulate a binary outcome with either a quadratic relationship or interaction}
\usage{
sim_dat(N, a1, a2 = NULL, a3 = NULL)
}
\arguments{
\item{N}{number of observations to simulate}

\item{a1}{value of the intercept term (in logits). This must be provided along with either \code{a2} or \code{a3}.}

\item{a2}{value of the quadratic coefficient. If specified the linear predictor is simulated as follows: \code{LP <- a1 + x1 + a2*x1^2} where \code{x1} is sampled from a standard normal distribution.}

\item{a3}{value of the interaction coefficient. If specified the linear predictor is simulated as follows: \code{LP <- a1 + x1 + x2 + x1*x2*a3} where \code{x1} and \code{x2} are sampled from independent standard normal distributions.}
}
\value{
a simulated data set with \code{N} rows. Can be split into 'development' and 'validation' sets.
}
\description{
Function for simulating data either with a single 'predictor' variable with a quadratic relationship with logit(p)
or two predictors that interact (see references for examples).
}
\examples{
library(pmcalibration)
# simulate some data with a binary outcome
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)

head(dat) # LP = linear predictor

}
\references{
Austin, P. C., & Steyerberg, E. W. (2019). The Integrated Calibration Index (ICI) and related metrics for quantifying the calibration of logistic regression models. Statistics in medicine, 38(21), 4051-4065.

Rhodes, S. (2022, November 4). Using restricted cubic splines to assess the calibration of clinical prediction models: Logit transform predicted probabilities first. https://doi.org/10.31219/osf.io/4n86q
}
