% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmevR6.R
\name{ev}
\alias{ev}
\title{Get linearly scaled variable based on optimal bins}
\description{
Get linearly scaled variable based on optimal bins

Get linearly scaled variable based on optimal bins
}
\details{
Finds outliers and then bands between 0 and 1 on optimal bins of
non-outlier data
}
\examples{
data(project)
tmp <- ev$new(start = project$start,
                       end = project$end,
                       progress = project$progress,
                       planned_cost = project$planned_cost,
                       project_value = 150000,
                       cost_to_date = 10000,
                       date = "2024-07-03")
plot(tmp)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{planned_value}}{(\code{numeric()})\cr
Planned value schedule}

\item{\code{earned_value}}{(\code{numeric()})\cr
Earned value calculations}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ev-new}{\code{ev$new()}}
\item \href{#method-ev-plot}{\code{ev$plot()}}
\item \href{#method-ev-clone}{\code{ev$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ev-new"></a>}}
\if{latex}{\out{\hypertarget{method-ev-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ev$new(
  start,
  end,
  progress,
  planned_cost,
  project_value,
  cost_to_date,
  date = today()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{Start Date of activity}

\item{\code{end}}{End Date of activity}

\item{\code{progress}}{Proportion between 0 and 1 representing percentage completed
for each activity (1 = 100\% complete)}

\item{\code{planned_cost}}{The planned costs of each activity}

\item{\code{project_value}}{The total value of the project}

\item{\code{cost_to_date}}{The total amount spent on the project to date}

\item{\code{date}}{Character date "YYYY-MM-DD". Defaults to today.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ev} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ev-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ev-plot}{}}}
\subsection{Method \code{plot()}}{
Plots the planned and earned values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ev$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ev-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ev-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ev$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
