% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{summary.internal_validate}
\alias{summary.internal_validate}
\title{Summarize a internal_validate object}
\usage{
\method{summary}{internal_validate}(object, ignore_scores = "^cal_plot", ...)
}
\arguments{
\item{object}{created by call to \code{\link{validate}}}

\item{ignore_scores}{a string used to identify scores to omit from summary.
\code{\link{score_binary}} produces scores with prefix 'cal_plot' when a calibration plot
is desired (see \code{\link{cal_plot}}) and these are ignored by default.}

\item{...}{ignored}
}
\value{
a data.frame with 4 columns (apparent score, optimism, bias-corrected score, number of successful resamples/folds)
and one row per score. Not all methods produce an optimism estimate so this row may be all NA. If confidence intervals
have been added for all measures via \code{\link{confint.internal_validate}}, two additional columns containing lower and upper bounds for
bias-corrected performance.
}
\description{
Summarize a internal_validate object
}
\examples{
library(pminternal)
set.seed(456)
# simulate data with two predictors that interact
dat <- pmcalibration::sim_dat(N = 2000, a1 = -2, a3 = -.3)
mean(dat$y)
dat$LP <- NULL # remove linear predictor

# fit a (misspecified) logistic regression model
m1 <- glm(y ~ ., data=dat, family="binomial")

# internal validation of m1 via bootstrap optimism with 10 resamples
# B = 10 for example but should be >= 200 in practice
m1_iv <- validate(m1, method="boot_optimism", B=10)
summary(m1_iv)

}
