% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmse_samplesize.R
\name{pmse_samplesize}
\alias{pmse_samplesize}
\title{Compute efficient sample size under user-defined PMSE targets}
\usage{
pmse_samplesize(
  k,
  p,
  PMSE_val_k = 1,
  PMSE_val_p = 1,
  efficiency_level = 0.9,
  sigma_k2 = NULL,
  sigma_p2 = NULL,
  cov = NULL,
  corr = NULL,
  SD = 1,
  f2 = NULL,
  f2_2 = NULL,
  R2_full = NULL,
  R2_basic = NULL
)
}
\arguments{
\item{k}{Integer. Total number of predictors in the full model.}

\item{p}{Integer. Number of basic predictors in the reduced model.}

\item{PMSE_val_k}{Numeric. Target PMSE value for the full model.}

\item{PMSE_val_p}{Numeric. Target PMSE value for the reduced model.}

\item{efficiency_level}{Numeric. Target efficiency level.
(default is 0.9, meaning 90\% of asymptotic pPMSEr)}

\item{sigma_k2}{Numeric. Predictor error variance for full model. If 'NULL'
it is derived.}

\item{sigma_p2}{Numeric. Predictor error variance for basic model. If 'NULL'
it is derived.}

\item{cov}{Optional covariance matrix. Must be \verb{(k+1) x (k+1)} with the response
1st row and column.}

\item{corr}{Optional correlation matrix. (Same layout as \code{cov}).}

\item{SD}{Optional numeric vector of standard deviation for the predictors when
a correlation matrix is supplied. Default \code{1}}

\item{f2}{Numeric. Cohen's f2 for effects of all predictors in full model.}

\item{f2_2}{Numeric. Cohen’s f2 for the effects of new predictors given
the basic model.}

\item{R2_full}{Numeric. Coefficient of determination for full model.}

\item{R2_basic}{Numeric. Coefficient of determination for basic model.}
}
\value{
Numeric representing the required sample size.
}
\description{
\code{pmse_samplesize} computes a sample size for a
prediction model. The function implements the formulas found in the thesis
"Predictive Power and Efficient Sample Size in Linear Regression Models" by Yifan Ma (2023).
}
\details{
pmse_samplesize
\itemize{
\item Sample Size Calculation for Prediction Models
}

\code{pmse_samplesize} The function calculates predictor error variance
for the full model, with all predictors, and the reduced model, with the basic
predictors using a provided covariance matrix or correlation matrix. It can
also calculate predictor error variance through Cohen's F^2 and R^2 values.
With the predictor error variance it determines a sample size from the
efficient sample size at a target efficiency level and a sample size from a
PMSE value of the full and reduced model. The final returned sample size is
the largest out of the outputs.
}
\examples{
## Example with a 5-predictor model (k = 5) and 2 basic predictors (p = 2)
pmse_samplesize(
  k = 5, p = 2,
  PMSE_val_k    = 1,
  PMSE_val_p    = 1,
  efficiency_level = 0.9,
  sigma_k2 = 0.50,
  sigma_p2 = 0.60
)

}
\references{
Ma, Y. (2023). \emph{Predictive Power and Efficient Sample Size in Linear
Regression Models}. Master’s Thesis, Worcester Polytechnic Institute.
}
