% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{gen_particles}
\alias{gen_particles}
\title{Generate proposal particles}
\usage{
gen_particles(
  num_particles,
  mu,
  sig2,
  particle,
  ...,
  mix_proportion = c(0.5, 0.5, 0),
  prop_mu = NULL,
  prop_sig2 = NULL,
  epsilon = 1
)
}
\arguments{
\item{num_particles}{The total number of particles to generate using a
combination of the three methods.}

\item{mu}{A vector of means for the multivariate normal}

\item{sig2}{A covariate matrix for the multivariate normal}

\item{particle}{A particle (re proposals for latent variables)}

\item{mix_proportion}{A vector of floats between 0 and 1 and summing to 1
which give the proportion of particles to generate from the population
level parameters, the individual random effects and the conditional
parameters respectively}

\item{epsilon}{Reduce the variance for the individual level samples by this
factor}
}
\value{
The new proposals
}
\description{
Generates particles for the \code{new_sample} function
}
\details{
Generate particles for a particular subject from a mix of population level
(hierarchical) distribution, from the particles (containing individual level
distribution) and/or from the conditional on accepted individual level
particles, a more efficient proposal method.

This function is used in burnin, adaptation and sampling using various
combinations of the arguments.
}
\keyword{internal}
