% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state_nlmixr.R
\name{der_vs_state_nlmixr}
\alias{der_vs_state_nlmixr}
\title{Generate Derivative versus State (nlmixr2)}
\usage{
der_vs_state_nlmixr(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  fit_obj = NULL,
  length_out = 100,
  time_nn = FALSE,
  act = "ReLU",
  beta = 20
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters form \emph{fit$fixef}. For optionality, see \strong{Details}.}

\item{fit_obj}{(nlmixr fit object; semi-optional) The fit-object from nlmixr2(...). For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of states between min_state and max_state for derivative calculations.}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}
}
\value{
Dataframe with columns for the state and the corresponding derivatives
}
\description{
This functions allows to generate derivative versus state data for a neural network from a NODE in nlmixr2.
}
\details{
Either \emph{est_parms} or \emph{fit_obj} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\author{
Dominic Bräm
}
\keyword{internal}
