% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geog.diffuse.R
\name{geog.diffuse}
\alias{geog.diffuse}
\title{Calculating Geographical Diffusion}
\usage{
geog.diffuse(df, id, neighbors, time, status, end = FALSE, keep = FALSE)
}
\arguments{
\item{df}{data frame to read in. Data frame should include a variable that is a character list of each observation's neighbors.}

\item{id}{the grouping variable, usually states or counties}

\item{neighbors}{a variable that is a \code{character} list of each observation's neighbors. The elements of the character list of neighbors should be separated by commas.}

\item{time}{the time variable, at which observations are measured.}

\item{status}{binary, user-defined measure of the status of policy or event in a state in a given year. \code{0} equates to \emph{policy has not yet occurred in the year, for the state}, \code{1} equates to \emph{policy event has already been adopted in the year, for the state} -- a value of \code{1} should exist for a state in the year it was adopted and every year thereafter). The example below relies on ERA ratification data from Soule and King (2006) <doi:10.1086/499908>, merged with ideology data from Berry et al. (1998) <doi:10.2307/2991759>, but the user should include the measure of adoption of their choice.}

\item{end}{logical (default set to \code{F}). When set to \code{end = T}, will calculate the percent of neighbors that had adopted policy by year-end. Otherwise, will calculate based on number of neighbors that had adopted the policy at year-start.}

\item{keep}{logical (default set to \code{F}). When set to \code{end = T}, will include additional variables (\emph{number of neighbors} and \emph{number of neighbors that had adopted the policy}) in the updated data frame.}
}
\value{
This function updates the data frame with a new variable capturing the geographical diffusion score.
}
\description{
Calculating Geographical Diffusion
}
\examples{
data <- Ideology_ERA

geog.diffuse(data, state, neighbors, year, era_status)
}
\references{
Berry, William D., Ringquist, Evan J., Fording, Richard C.,
and Hanson, Russell L.
(1998) 'Measuring Citizen and Government Ideology 
in the American States, 1960-93.' 
\emph{American Journal of Political Science} 42:327-348.
\doi{10.2307/2991759}.\cr
Soule, Sarah A., and King, Brayden G.
(2006) 'The Stages of the Policy Process 
and the Equal Rights Amendment, 1972-1982.' 
\emph{American Journal of Sociology} 111:1871-1909.
\doi{10.1086/499908}.\cr

This function calculates the percent (or proportion) of geographically contiguous neighbors that have engaged in some \emph{event} (e.g. policy adoption) in a given year. This function can be applied to any unit of analysis and time level for any type of event.
}
