% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape.R
\name{scrape}
\alias{scrape}
\title{Scrape the content of authorized page/API}
\usage{
scrape(
  bow,
  query = NULL,
  params = NULL,
  accept = "html",
  content = NULL,
  verbose = FALSE
)
}
\arguments{
\item{bow}{host introduction object of class \code{polite}, \code{session} created by \code{bow()} or \code{nod()}}

\item{query}{named list of parameters to be appended to URL in the format \code{list(param1=valA, param2=valB)}}

\item{params}{deprecated. Use \code{query} argument above.}

\item{accept}{character value of expected data type to be returned by host (e.g. \code{html}, \code{json}, \code{xml}, \code{csv}, \code{txt}, etc.)}

\item{content}{MIME type (aka internet media type) used to override the content type returned by the server.
See http://en.wikipedia.org/wiki/Internet_media_type for a list of common types. You can add the \code{charset} parameter to override the server's default encoding}

\item{verbose}{extra feedback from the function. Defaults to \code{FALSE}}
}
\value{
Object of class \code{httr::response} which can be further processed by functions in \code{rvest} package
}
\description{
Scrape the content of authorized page/API
}
\examples{
\donttest{
 library(rvest)
  bow("https://en.wikipedia.org/wiki/List_of_cognitive_biases") \%>\%
   scrape(content="text/html; charset=UTF-8") \%>\%
   html_nodes(".wikitable") \%>\%
   html_table()
}

}
