% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyMatrix-package.R
\docType{package}
\name{polyMatrix-package}
\alias{polyMatrix-package}
\alias{_PACKAGE}
\title{Implementation of matrices of polynomials}
\description{
Implementation of class "polyMatrix" for storing a matrix of polynomials and implements 
  basic matrix operations; including a determinant and characteristic polynomial.
  It is based on the package 'polynom' and uses a lot of its methods to implement matrix operations.
  This package includes 3 methods of triangularization of polynomial matrices:
  Extended Euclidean algorithm which is most classical but numerically unstable;
  Sylvester algorithm based on LQ decomposition;
  Interpolation algorithm is based on LQ decomposition and Newton interpolation.
  Both methods are described in 
  D. Henrion & M. Sebek, Reliable numerical methods for polynomial matrix triangularization,
  IEEE Transactions on Automatic Control (Volume 44, Issue 3, Mar 1999, Pages 497-508) <doi:10.1109/9.751344>
  and in 
  Salah Labhalla, Henri Lombardi & Roger Marlin, 
  Algorithmes de calcule de la reduction de Hermite d'une matrice a coefficients polynomeaux,
  Theoretical Computer Science (Volume 161, Issue 1-2, July 1996, Pages 69-92) <doi:10.1016/0304-3975(95)00090-9>.
}
\details{
This package add transperent support of matrices of polynomials to \R language.
}
\section{Input}{

\itemize{
\item low level input of matrix: \code{\link[=polyMatrix]{polyMatrix()}}
\item string ibpuy of polynomial: \code{\link[=parse.polynomial]{parse.polynomial()}}
\item string input of matrix: \code{\link[=parse.polyMatrix]{parse.polyMatrix()}}
}
}

\section{Output}{


Matrices of polynomials uses same format as numerical matrices
}

\section{Operators}{


Basic arithmetic operations were implemented.
}

\section{Functions}{


The most important matrix functions are implemented:
\itemize{
\item the determinant \code{\link[=det]{det()}}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/namezys/polymatrix}
  \item Report bugs at \url{https://github.com/namezys/polymatrix/issues}
}

}
\author{
\strong{Maintainer}: Nikolai Ryzhkov \email{namezys@gmail.com} (\href{https://orcid.org/0000-0003-4896-280X}{ORCID})

Authors:
\itemize{
  \item Tamas Prohle \email{prohlet@ludens.elte.hu}
  \item Peter Prohle \email{prohlep@math.elte.hu}
  \item Ildiko Laszlo (\href{https://orcid.org/0000-0003-2324-8183}{ORCID})
}

Other contributors:
\itemize{
  \item Ulas Onat Alakent [contributor]
}

}
\keyword{internal}
