% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr.R
\name{d_mvmf_polysph}
\alias{d_mvmf_polysph}
\title{Density of the product of von Mises--Fisher distributions on the
polysphere}
\usage{
d_mvmf_polysph(x, d, mu, kappa, prop, log = FALSE)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, sum(d) + r)} with the evaluation
points.}

\item{d}{vector of size \code{r} with dimensions.}

\item{mu}{a matrix of size \code{c(m, sum(d + 1))} with the means of
each mixture components in the rows.}

\item{kappa}{a matrix of size \code{c(m, r)} with the concentrations of
each mixture components in the rows.}

\item{prop}{a vector of size \code{m} with the proportions of the mixture
components.}

\item{log}{compute the logarithm of the density? Defaults to \code{FALSE}.}
}
\value{
A vector of size \code{nx} with the evaluated density.
}
\description{
Computes the density of an \eqn{m}-mixture of product of von
Mises--Fisher densities on the polysphere.
}
\examples{
# Simple check of integration on S^1 x S^2
d <- c(1, 2)
mu <- rbind(c(0, 1, 0, 1, 0), c(1, 0, 1, 0, 0))
kappa <- rbind(c(5, 2), c(1, 2))
prop <- c(0.7, 0.3)
x <- r_mvmf_polysph(n = 1e4, d = d, mu = mu, kappa = kappa, prop = prop)
mean(1 / d_mvmf_polysph(x = x, d = d, mu = mu, kappa = kappa, prop = prop)) /
  prod(rotasym::w_p(p = d + 1))
}
