% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_stdcumul.R
\encoding{UTF-8}
\name{ind_stdcumul}
\alias{ind_stdcumul}
\title{Assess polypharmacy based on the average number of distinct medications consumed over successive periods of time of equal length}
\usage{
ind_stdcumul(
  processed_tab,
  nPeriod = 1,
  stats = c("mean", "sd", "min", "p5", "p10", "p25", "median", "p75", "p90", "p95",
    "max")
)
}
\arguments{
\item{processed_tab}{Table of individual drug treatments over the study period. Created by \code{\link{data_process}} function.}

\item{nPeriod}{Number of subperiods of equal time length in which the study period will be subdivided: Integer value greater or equal to 1 and lesser or equal to the total number of days in the study period. If \code{nPeriod} is greater than 1, the study period is divided in \code{nPeriod} subperiods and the number of medications consumed in each subperiod is averaged over the number of subperiods.}

\item{stats}{Cohort descriptive statistics to calculate on the polypharmacy indicator. See \emph{Details} for possible values.}
}
\value{
\code{list}:
\itemize{
\item \code{indic}: \code{data.table} indicating each \code{stats} (columns).
\item \code{stats_id}: \code{data.table}. For each individual (all cohort), indicate the number of drug use per period (\code{perX} where \code{X} is a number between 1 and \code{nPeriod}) and the mean of the periods (\code{nRx}).
}
}
\description{
Averages the number of distinct medications that are consumed by every individual during successive periods of time of equal length and provides cohort descriptive statistics on this indicator.
}
\details{
\strong{stats:} Possible values are
\itemize{
\item \code{'mean'}, \code{'min'}, \code{'median'}, \code{'max'}, \code{'sd'};
\item \code{'pX'} where \emph{X} is an integer value in ]0, 100];
\item \code{'q1'}=\code{'p25'}, \code{'q2'}=\code{'p50'}=\code{'median'}, \code{q3}=\code{'p75'}.
}
}
\examples{
rx1 <- data.frame(id = c(1, 1, 1, 2),
                  code = c("A", "B", "C", "A"),
                  date = c("2000-01-01", "2000-01-01", "2000-01-26", "2000-01-17"),
                  duration = c(30, 5, 5, 10))
cohort1 <- data.frame(id = as.numeric(1:3),
                      age = c(45, 12, 89),
                      sex = c("F", "F", "M"))
rx_proc1 <- data_process(Rx_deliv = rx1, Rx_id = "id", Rx_drug_code = "code",
                         Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
                         Cohort = cohort1, Cohort_id = "id",
                         study_start = "2000-01-01", study_end = "2000-01-30",
                         cores = 1)
# 1 period
dt_ind_stdcumul_per1 <- ind_stdcumul(processed_tab = rx_proc1, nPeriod = 1)
# 3 periods
dt_ind_stdcumul_per3 <- ind_stdcumul(processed_tab = rx_proc1, nPeriod = 3)
}
