% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_Posteriors}
\alias{plot_Posteriors}
\title{Plot multiple posterior distributions}
\usage{
plot_Posteriors(posteriors, index, limits, weights = NULL)
}
\arguments{
\item{posteriors}{is a list with samples from the posterior distributions
obtained for each target. Each entry of the list is a matrix where each row
corresponds to a different accepted simulations and each column corresponds
to a different parameter.}

\item{index}{an non-negative integer indicating which parameter to plot. It
corresponds to the desired column of a matrix in the \code{posteriors} input.
So, to plot the first parameter, corresponding to the first column in the
\code{posteriors} input select 1. To plot the second parameter, select 2 and so
on.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{weights}{is an optional list input containing the weights from the
local linear regression method. Each entry of the list should be a numeric
vector with the weights for each accepted simulation.}
}
\value{
a plot with multiple posterior distributions, each obtained for a
different target, for the selected parameter.
}
\description{
Plots, in the same plot, the density of multiple posterior distributions of a
given parameter.
}
\details{
After using the \code{\link[=multipleABC]{multipleABC()}} or \code{\link[=ABC]{ABC()}} functions to perform parameter
estimation with Approximate Bayesian Computation with several targets, this
function can be used for a quick visualization of the quality of an ABC
analysis. Multiple posterior distributions, each obtained for a different
target, are plotted in the same plot, allowing for a visualization of the
shape of the posteriors and a quick inspection of whether all the posteriors
converge to the same estimate.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select some random simulations to act as target just to test the function
targets <- sumstats[c(11:20) ,]
# we should remove those random simulation from the sumstats and params matrices
sumstats <- sumstats[-c(11:20), ]; params <- params[-c(11:20), ]

# parameter estimation for a single target
myabc <- multipleABC(targets = targets, params = params, sumstats = sumstats, limits = limits,
tol = 0.01, method = "regression")

# plot multiple posteriors
plot_Posteriors(posteriors = myabc$adjusted, index = 1, limits = limits, weights = myabc$weights)

# note that this is just an example!
# we don't have enough simulations to obtain credible results

}
