% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_stats}
\alias{plot_stats}
\title{Plot the fit of a summary statistic to the target}
\usage{
plot_stats(sumstat, target, accepted, index = NA, colour = TRUE)
}
\arguments{
\item{sumstat}{is a vector or matrix of simulated summary statistics. If this
input is a vector, then each entry should correspond to a different
simulation. If it is a matrix, then each row should be a different
simulation and each column a different statistic. Note that this should be
the entire set of simulated values.}

\item{target}{is an integer or a numeric vector containing the target of the
parameter inference. If a single integer, then this should be the target
summary statistic corresponding to the input \code{sumstat} vector. If this
input is a vector, then the order of the entries in the vector should be
the same as the order of the columns of the \code{sumstat} matrix input. Either
way, this input should contain the value of the summary statistics
calculated from observed data.}

\item{accepted}{is a vector or matrix of accepted summary statistics. If this
input is a vector, then each entry should correspond to a different
simulation. If it is a matrix, then each row should be a different
simulation and each column a different statistic. Note that this should be
summary statistics of the accepted simulations during parameter inference.}

\item{index}{is an optional non-negative integer. This input is only required
when the \code{sumstat} and \code{accepted} inputs are matrices. In that instance, it
will indicate which summary statistic to plot. It corresponds to the
desired column of the \code{sumstat} and \code{accepted} matrices and to the entry of
the \code{target} vector.}

\item{colour}{logical, indicating whether the plot should be a colour version
(default) or a grayscale plot.}
}
\value{
a plot with the fit of the simulated summary statistics to the
observed value. Both the density estimation of the entire simulated summary
statistics and the accepted summary statistics are contrasted with the
observed value.
}
\description{
Plot the fit of a summary statistic to the target
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]
# we should remove the random simulation from the sumstats and params matrices
sumstats <- sumstats[-10, ]; params <- params[-10, ]

# parameter estimation for a single target
myabc <- singleABC(target = target, params = params, sumstats = sumstats,
limits = limits, tol = 0.01, method = "regression")

# check the fit of a summary statistic to the target
plot_stats(sumstat = sumstats, target = target, accepted = myabc$ss, index = 5)

# note that we performed parameter estimation for a single target
# because this function will only work when using a matrix

}
