% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_F3fromF2samples}
\alias{compute_F3fromF2samples}
\alias{.compute_F3fromF2samples}
\title{compute_F3fromF2samples}
\usage{
.compute_F3fromF2samples(blockF2, blockHet, npops, verbose)
}
\arguments{
\item{blockF2}{Numeric Matrix with nF2=(npop*(npop-1))/2 rows and nblocks columns matrix containing pairwise-pop F2 estimates for each block-jackknife sample (l.o.o.)}

\item{blockHet}{Numeric Matrix with npop rows and nblocks columns containing all within pop heterozygosity estimates for each block-jackknife sample (l.o.o.)}

\item{npops}{Integer giving the number of populations}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a matrix with nF3=npops*(npops-1)*(npops-2)/2 rows and four columns corresponding to the mean and the s.e. of F3 and the mean and s.e. of F3star
}
\description{
Compute all F3 from F2 values obtained from each block-jackknife bloc
}
\details{
Compute F3 and F3star estimates and their s.e. based on block-jackknife estimates of all F2 (and heterozygosities)
}
\examples{
#
}
