% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matlab2R.R
\name{Matlab2R}
\alias{Matlab2R}
\title{Read Matlab style matrices into R}
\usage{
Matlab2R(M)
}
\arguments{
\item{M}{an object of class character that represents a numeric matrix coded 
in a Matlab style.}
}
\value{
An object of class matrix.
}
\description{
Read a matrix coded in a Matlab style into \R to create an object of class
matrix
}
\details{
Matlab reads matrices using a unique one-line notation that can prove useful 
for storage in databases and importing multiple matrices into a program at 
once, amongst other applications. This notation is by row, with "[" and "]" 
to specify the beginning and end of the matrix respectively, ";" to specify a 
new row and a space between each matrix element. Thus, the \R matrix created 
using \code{matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3)} is 
equivalent to [0 1 2;0.5 0.1 0;0 0.6 0.6].

\code{Matlab2R} takes a Matlab-coded matrix expressed as a character string 
and converts it into an \R object of class matrix. As well as providing a 
simpler means of matrix notation in \R, it also enables simultaneous import of 
multiple matrices of varying dimensions, using comma-seperated dataframes and 
tables.
}
\examples{
  # Create a 3x3 PPM using Matlab2R
  ( A<-Matlab2R("[0 1 2;0.5 0.1 0;0 0.6 0.6]") )

}
\seealso{
\code{\link{R2Matlab}}
}
\concept{Matlab}
