% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phylo.R
\name{plot_phylo}
\alias{plot_phylo}
\title{Plot a \code{phylo} tree object}
\usage{
plot_phylo(
  tree,
  xlab = "Coancestry",
  xmax = NULL,
  leg_n = 5,
  edge_width = 1,
  ...
)
}
\arguments{
\item{tree}{A \code{phylo} object to plot.}

\item{xlab}{The x-axis label (default "Coancestry").}

\item{xmax}{X-axis maximum limit.}

\item{leg_n}{The desired number of ticks in the x-axis (input to \code{\link[=pretty]{pretty()}}, see that for more details).}

\item{edge_width}{The width of the tree edges (passed to \code{\link[ape:plot.phylo]{ape::plot.phylo()}} as \code{edge.width}).}

\item{...}{Additional parameters passed to \code{\link[ape:plot.phylo]{ape::plot.phylo()}}.
However, these parameters cannot be passed: \code{x.lim} (controlled via \code{xmax}), \code{y.lim} (a better default for small trees is passed and cannot be changed) and \code{font} (takes the value of \code{par('font')} instead of \code{ape}'s default of 3 (italic)).}
}
\description{
This is a wrapper around \code{\link[ape:plot.phylo]{ape::plot.phylo()}} that makes several adjustments so plots agree more with accompanying kinship matrices.
In particular, tree is reversed on the y-axis to match matrix orientation, y-axis spacing is more padded for small trees, and an x-axis scale is always added.
}
\examples{
# create a small random tree
library(ape)
tree <- rtree( 3 )

# plot it!
plot_phylo( tree )

}
\seealso{
\code{\link[=plot_popkin]{plot_popkin()}} can create multipanel figures including kinship matrices and trees (calling the present function in the process).
}
