% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmigration_projection.R
\name{netmigration_projection}
\alias{netmigration_projection}
\title{netmigration_projection}
\usage{
netmigration_projection(
  mortality_rates_path,
  TFR_path,
  total_population_path,
  WRA_path,
  omega_age,
  horizon,
  first_year_projection
)
}
\arguments{
\item{mortality_rates_path}{character. Path to Mortality rates in a .txt file.}

\item{TFR_path}{character. Path to Fertility rates in a .txt file.}

\item{total_population_path}{character. Path to Populations in a .txt file.}

\item{WRA_path}{character. Path to Women of Reproductive Age in a .txt file.}

\item{omega_age}{numeric. Maximum age.}

\item{horizon}{numeric. The forecast horizon.}

\item{first_year_projection}{numeric. Year for the base population.}
}
\value{
\code{netmigration_projection} returns an object of class \code{fmforecast} with the forecast netmigration models and the components of \code{\link[demography]{forecast.fdmpr}}.
}
\description{
Forecasting net migration.
}
\examples{

\donttest{
\dontrun{

library(dplyr)

data(CR_mortality_rates_1950_2011)

#CR_mortality_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_mortality_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_populations_1950_2011)

#CR_populations_1950_2011 \%>\%
#write.table(.,
#file = "CR_populations_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

data(CR_fertility_rates_1950_2011)

#CR_fertility_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_fertility_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_women_childbearing_age_1950_2011)

#CR_women_childbearing_age_1950_2011 \%>\%
#write.table(.,
#file = "CR_women_childbearing_age_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

#result <- netmigration_projection(mortality_rates_path = "CR_mortality_rates_1950_2011.txt",
#total_population_path = "CR_populations_1950_2011.txt",
#TFR_path = "CR_fertility_rates_1950_2011.txt",
#WRA_path = "CR_women_childbearing_age_1950_2011.txt",
#omega_age = 115, first_year_projection = 2011, horizon = 2150)

}
}

}
\author{
Cesar Gamboa-Sanabria
}
