% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{logit}
\alias{logit}
\alias{invlogit}
\title{Logit and Inverse-Logit Functions}
\usage{
logit(p)

invlogit(x)
}
\arguments{
\item{p}{Values in the interval \verb{[0, 1]}.
Can be an atomic vector, a matrix,
or an \link[rvec:rvec]{rvec}.}

\item{x}{Values in the interval \verb{(-Inf, Inf)}.
Can be an atomic vector, a matrix,
or an \link[rvec:rvec]{rvec}.}
}
\value{
\itemize{
\item A vector of doubles, if \code{p} or \code{x} is a vector.
\item A matrix of doubles, if \code{p} or \code{x} is a matrix.
\item An object of class \code{rvec_dbl}, if \code{p} or \code{x} is an rvec.
}
}
\description{
Transform values to and from the logit scale.
\code{logit()} calculates
}
\details{
\deqn{x = \log \left(\frac{p}{1 - p}\right)}

and \code{invlogit()} calculates

\deqn{p = \frac{e^x}{1 + e^x}}

To avoid overflow, \code{invlogit()}
uses \eqn{p = \frac{1}{1 + e^{-x}}}
internally for \eqn{x} where \eqn{x > 0}.

In some of the demographic literature,
the logit function is defined as

\deqn{x = \frac{1}{2} \log \left(\frac{p}{1 - p}\right).}

\code{logit()} and \code{invlogit()} follow the conventions
in statistics and machine learning, and omit the
\eqn{\frac{1}{2}}.
}
\examples{
p <- c(0.5, 1, 0.2)
logit(p)
invlogit(logit(p))
}
