% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsNtables.R
\name{summaryTable}
\alias{summaryTable}
\title{Create table from backtest summary}
\usage{
summaryTable(
  bt_summary,
  measures = NULL,
  caption = "Performance table",
  type = c("simple", "DT", "kable", "grid.table"),
  digits = 2,
  order_col = NULL,
  order_dir = c("asc", "desc"),
  page_length = 10
)
}
\arguments{
\item{bt_summary}{Backtest summary as obtained from the function \code{backtestSummary}.}

\item{measures}{String vector to select performane measures (default is all) from
`Sharpe ratio`, `max drawdown`, `annual return`, `annual volatility`, 
`Sterling ratio`, `Omega ratio`, `ROT bps`, etc.}

\item{caption}{Table caption (only works for \code{type = "DT"}).}

\item{type}{Type of table. Valid options: \code{"simple", "DT", "kable", "grid.table"}. Default is 
\code{"simple"} and generates a simple matrix (with the other choices the 
corresponding package must be installed).}

\item{digits}{Integer indicating the number of decimal places when rounding (default is 2).}

\item{order_col}{Column number or column name of the performance measure to be used to 
sort the rows (only used for table \code{type = "DT"}). By default the 
last column will be used.}

\item{order_dir}{Direction to be used to sort the rows (only used for table 
\code{type = "DT"}). Valid options: \code{"asc", "desc"}. 
Default is \code{"asc"}.}

\item{page_length}{Page length for the table (only used for table \code{type = "DT"}). 
Default is \code{10}.}
}
\description{
After performing a backtest with \code{\link{portfolioBacktest}} 
and obtaining a summary of the performance measures with 
\code{\link{backtestSummary}}, this function creates a table from the summary. 
By default the table is a simple matrix, but if the user has installed the 
package \code{DT} or \code{grid.table} nicer tables can be generated.
}
\examples{
\donttest{ 
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
quintile_portfolio <- function(data, ...) {
  X <- diff(log(data$adjusted))[-1]  
  N <- ncol(X)
  ranking <- sort(colMeans(X), decreasing = TRUE, index.return = TRUE)$ix
  w <- rep(0, N)
  w[ranking[1:round(N/5)]] <- 1/round(N/5)
  return(w)
}

# do backtest
bt <- portfolioBacktest(list("Quintile" = quintile_portfolio), 
                        dataset10,
                        benchmark = c("1/N", "index"))

# now we can obtain the table
bt_summary_median <- backtestSummary(bt)
summaryTable(bt_summary_median, measures = c("max drawdown", "annual volatility"))
summaryTable(bt_summary_median, measures = c("max drawdown", "annual volatility"), type = "DT")
summaryTable(bt_summary_median, type = "kable") 
# this returned kable object can be combined with: " |> kableExtra::kable_styling()"
}

}
\seealso{
\code{\link{summaryBarPlot}}
}
\author{
Daniel P. Palomar and Rui Zhou
}
