% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_ratio_functions.R
\name{wprod}
\alias{wprod}
\title{The product-order win function for multivariate ordinal data}
\usage{
wprod(y1, y0)
}
\arguments{
\item{y1}{A \eqn{K}-dimensional vector \eqn{y_1}.}

\item{y0}{A \eqn{K}-dimensional vector  \eqn{y_0}.}
}
\value{
An integer in \eqn{{1, 0, -1}}:
        \item{1}{If \eqn{y_1 \ge y_0} component-wise, with strict inequality for at least
                 one component.}
        \item{-1}{If \eqn{y_0 \ge y_1} component-wise, with strict inequality for at least
                 one component.}
        \item{0}{Otherwise.}
}
\description{
A common rule of comparison for the \code{fun} argument
   in \code{\link{wrtest}} and \code{\link{wreg}}.
   A winner has all its components
   greater than or equal to those of the loser, and strictly
   so for at least one component.
}
\seealso{
\code{\link{wrtest}}, \code{\link{wreg}}.
}
\keyword{wrtest}
