% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExactMRP.R
\name{ExactMRP}
\alias{ExactMRP}
\title{Computing Mutual Ranking Probabilities (MRP).}
\usage{
ExactMRP(poset, output_every_sec = NULL)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet} representing the poset whose MRP are computed.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{output_every_sec}{Integer specifying a time interval (in seconds).
By specifying this argument, during the execution of \code{ExactMRP} a message reporting the number of linear extensions progressively generated
is printed on the R-Console, every \code{output_every_sec} seconds.}
}
\value{
A list of two elements: 1) the MRP matrix and 2) the number of linear extensions generated to compute it.
}
\description{
Computes the MRP matrix of a poset. The MRP associated to \eqn{a\leq b}, with \eqn{a} and \eqn{b} two elements of the input poset, is the share of linear extensions of it where \eqn{b} dominates \eqn{a}. The linear extensions are computed according to the algorithm given in Habib M, Medina R, Nourine L and Steiner G (2001).
}
\examples{
\donttest{
el1 <- c("a", "b", "c", "d")
el2 <- c("x", "y")
el3 <- c("h", "k")
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = el1, dom = dom)

pos2 <- LinearPOSet(elements = el2)

pos3 <- LinearPOSet(elements = el3)

pos <- ProductPOSet(pos1, pos2, pos3)

MRP <- ExactMRP(pos, output_every_sec=1)
}

}
\references{
Habib M, Medina R, Nourine L and Steiner G (2001). Efficient algorithms on distributive lattices.
Discrete Applied Mathematics, 110, 169-187. https://doi.org/10.1016/S0166-218X(00)00258-4.
}
