% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGenerator.R
\name{LEGenerator}
\alias{LEGenerator}
\title{Generator of all the linear extensions of a poset.}
\usage{
LEGenerator(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet} representing the poset whose linear extensions are generated.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
An S4 class object \code{LEGenerator}.
}
\description{
Creates an object of S4 class \code{LEGenerator} to generate all of the linear extensions of a given poset.
Actually, this function does not generate the linear extensions, but just the object that will generate them
by using function \code{LEGet}.
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

LEgen <- LEGenerator(pos)


}
