% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/part1_csv_data_transform.R
\name{ggir.datatransform}
\alias{ggir.datatransform}
\title{Transform the data and merge all accelerometer files in the GGIR output}
\usage{
ggir.datatransform(
  outputdir,
  subdir,
  studyname,
  numericID = FALSE,
  sortByid = "newID",
  f0 = 1,
  f1 = 1e+06,
  epochIn = 5,
  epochOut = 600,
  mergeVar = 1
)
}
\arguments{
\item{outputdir}{\code{character} Directory where the GGIR output was stored.}

\item{subdir}{\code{character} Sub-directory where the summary output was stored under the current directory. Defaut is "data".}

\item{studyname}{\code{character} Specify the study name that used in the output file names}

\item{numericID}{\code{logical} Specify if the ID is numeric when checking ID errors in part2. Default is FALSE.}

\item{sortByid}{\code{character}  Specify the name of "ID" for each accelerometer file in the report of part5. The value could be "newID","id" and "filename". Defaut is "filename".}

\item{f0}{\code{number}  File index to start with (default = 1). Index refers to the filenames sorted in increasing order.}

\item{f1}{\code{number}  File index to finish with. Note that file ends with the minimum of f1 and the number of files available. Default = 1000000.}

\item{epochIn}{\code{number}  Epoch size to which acceleration was averaged (seconds) in GGIR output. Defaut is 5 seconds.}

\item{epochOut}{\code{number}  Epoch size to which acceleration was averaged (seconds) in part1. Defaut is 600 seconds.}

\item{mergeVar}{\code{number}  Specify which of the varaible need to be processed and merged. For example, mergeVar = 1 makes that the M$metalong varialbes were read from R data on the directory of /meta/basic under GGIR ourput directory, which includes "nonwearscore","clippingscore","lightmean","lightpeak","temperaturemean" and "EN".  When mergeVar = 2, makes that the "enmo" and "anglez" varialbes were read from csv data on the directory of /meta/csv under GGIR ourput directory.}
}
\value{
\item{     mergeVar = 1}{Six files were written to the specified sub-directory as follows,}
\item{       nonwearscore_studyname_f0_f1_Xs.xlsx}{Data matrix of nonwearscore, where f0 and f1 are the file index to start and finish with and Xs is the epoch size to which acceleration was averaged (seconds) in GGIR output.}  
\item{       clippingscore_studyname_f0_f1_Xs.xlsx}{Data matrix of clippingscore} 
\item{       lightmean_studyname_f0_f1_Xs.xlsx}{Data matrix of lightmean} 
\item{       lightpeak_studyname_f0_f1_Xs.xlsx}{Data matrix of lightpeak} 
\item{       temperaturemean_studyname_f0_f1_Xs.xlsx}{Data matrix of temperaturemean} 
\item{         EN_studyname_f0_f1_Xs.xlsx}{Data matrix of EN} 


\item{     mergeVar = 2}{Two files were written to the specified sub-directory as follows,}
\item{       studyname_ENMO.dataf0_f1_Xs.xlsx}{Data matrix of ENMO, where f0 and f1 are the file index to start and finish with and Xs is the epoch size to which acceleration was averaged (seconds) in GGIR output.} 
\item{       studyname_ANGLEZ.dataf0_f1_Xs.xlsx}{Data matrix of ANGLEZ}
}
\description{
An accelerometer file was transformed into wide data matrix, in which the rows represent available days and the columns including all timestamps for 24 hours. Further, the wide data was merged together.
}
