% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_power_plot.R
\name{repeat_power_linear}
\alias{repeat_power_linear}
\alias{plot.postcard_rpl}
\title{Create data and plot power curves calculated using functions in \code{\link[=power_linear]{power_linear()}} for a list of formulas/models}
\usage{
repeat_power_linear(
  ate,
  formula_list,
  train_data,
  power_fun = c("power_gs", "power_nc"),
  ns = 10:400,
  desired_power = 0.9,
  ...
)

\method{plot}{postcard_rpl}(x, cols = NULL, ...)
}
\arguments{
\item{ate}{Passed to \code{\link[=power_gs]{power_gs()}} or \code{\link[=power_nc]{power_nc()}}}

\item{formula_list}{a named \code{list} of formulas that are element wise passed to
\code{\link[=variance_ancova]{variance_ancova()}}}

\item{train_data}{Passed as the \code{data} argument in \code{\link[=variance_ancova]{variance_ancova()}}}

\item{power_fun}{a \code{character} string with value \code{"power_gs"} or \code{"power_nc"},
specifying what function in the \code{\link[=power_linear]{power_linear()}} topic to use}

\item{ns}{a \code{numeric} vector of sample sizes}

\item{desired_power}{a \code{numeric} between 0 and 1 indicating the desired power level}

\item{...}{Arguments passed to \code{\link[=variance_ancova]{variance_ancova()}} and \code{\link[=power_gs]{power_gs()}} or \code{\link[=power_nc]{power_nc()}}}

\item{x}{an object of class \code{postcard_rpl} created by \code{repeat_power_linear()}}

\item{cols}{a (potentially named) \code{character} vector of colors for the different models
in \code{formula_list}}
}
\value{
\code{repeat_power_linear} returns an object of class \code{postcard_rpl}, which is
just a \code{data.frame} with a \code{plot} method defined. The \code{plot} method returns a
\code{ggplot2} object.
}
\description{
Estimate a variance for power approximation using \code{\link[=variance_ancova]{variance_ancova()}} for each formula
in \code{formula_list} on \code{train_data}. Then calculate power using the function with name
specified in \code{power_fun} across a number of sample sizes \code{ns} for an assumed average
treatment effect of \code{ate}.
}
\examples{
train_data <- glm_data(
  Y ~ 1+1.5*log(W)+2*X,
  W = runif(1e3, min = 1, max = 10),
  X = rnorm(1e3, sd = 3)
)
rpl <- repeat_power_linear(
  ate = 0.5,
  formula_list = list("ANCOVA 1 covariate" = Y ~ X, "ANCOVA 2 covariates" = Y ~ W + X),
  train_data = train_data)

rpl_nc <- repeat_power_linear(
  ate = 0.5,
  formula_list = list("ANCOVA 1 covariate" = Y ~ X, "ANCOVA 2 covariates" = Y ~ W + X),
  train_data = train_data,
  power_fun = "power_nc",
  df = 1e3-3,
  deflation = 0.95,
  margin = -0.2,
  r = 2)

\dontrun{
plot(rpl)

plot(rpl_nc)
}
}
\seealso{
\code{\link[=repeat_power_marginaleffect]{repeat_power_marginaleffect()}} for a similar implementation to iterate the
process of approximating power with the \code{\link[=power_marginaleffect]{power_marginaleffect()}}
}
